/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.skywalking.apm.util.StringUtil;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.query.enumeration.Order;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.input.TopNCondition;
import org.apache.skywalking.oap.server.core.query.type.SelectedRecord;
import org.apache.skywalking.oap.server.core.storage.query.ITopNRecordsQueryDAO;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCHikariCPClient;

public class H2TopNRecordsQueryDAO
implements ITopNRecordsQueryDAO {
    private JDBCHikariCPClient h2Client;

    public H2TopNRecordsQueryDAO(JDBCHikariCPClient h2Client) {
        this.h2Client = h2Client;
    }

    public List<SelectedRecord> readSampledRecords(TopNCondition condition, String valueColumnName, Duration duration) throws IOException {
        StringBuilder sql = new StringBuilder("select * from " + condition.getName() + " where ");
        ArrayList<Object> parameters = new ArrayList<Object>(10);
        if (StringUtil.isNotEmpty((String)condition.getParentService())) {
            sql.append(" service_id = ? and");
            String serviceId = IDManager.ServiceID.buildId((String)condition.getParentService(), (boolean)condition.isNormal());
            parameters.add(serviceId);
        }
        sql.append(" ").append("time_bucket").append(" >= ?");
        parameters.add(duration.getStartTimeBucketInSec());
        sql.append(" and ").append("time_bucket").append(" <= ?");
        parameters.add(duration.getEndTimeBucketInSec());
        sql.append(" order by ").append(valueColumnName);
        if (condition.getOrder().equals((Object)Order.DES)) {
            sql.append(" desc ");
        } else {
            sql.append(" asc ");
        }
        sql.append(" limit ").append(condition.getTopN());
        ArrayList<SelectedRecord> results = new ArrayList<SelectedRecord>();
        try (Connection connection = this.h2Client.getConnection();
             ResultSet resultSet = this.h2Client.executeQuery(connection, sql.toString(), parameters.toArray(new Object[0]));){
            while (resultSet.next()) {
                SelectedRecord record = new SelectedRecord();
                record.setName(resultSet.getString("statement"));
                record.setRefId(resultSet.getString("trace_id"));
                record.setId(record.getRefId());
                record.setValue(resultSet.getString(valueColumnName));
                results.add(record);
            }
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
        return results;
    }
}

