/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao;

import com.google.gson.JsonObject;
import java.sql.Connection;
import java.sql.SQLException;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.NodeType;
import org.apache.skywalking.oap.server.core.storage.StorageException;
import org.apache.skywalking.oap.server.core.storage.model.ColumnName;
import org.apache.skywalking.oap.server.core.storage.model.Model;
import org.apache.skywalking.oap.server.core.storage.model.ModelColumn;
import org.apache.skywalking.oap.server.core.storage.model.ModelInstaller;
import org.apache.skywalking.oap.server.core.storage.type.StorageDataComplexObject;
import org.apache.skywalking.oap.server.library.client.Client;
import org.apache.skywalking.oap.server.library.client.jdbc.JDBCClientException;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCHikariCPClient;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.SQLBuilder;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.TableMetaInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class H2TableInstaller
extends ModelInstaller {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(H2TableInstaller.class);
    public static final String ID_COLUMN = "id";

    public H2TableInstaller(Client client, ModuleManager moduleManager) {
        super(client, moduleManager);
    }

    protected boolean isExists(Model model) throws StorageException {
        TableMetaInfo.addModel(model);
        return false;
    }

    protected void createTable(Model model) throws StorageException {
        JDBCHikariCPClient jdbcHikariCPClient = (JDBCHikariCPClient)this.client;
        try (Connection connection = jdbcHikariCPClient.getConnection();){
            SQLBuilder tableCreateSQL = new SQLBuilder("CREATE TABLE IF NOT EXISTS " + model.getName() + " (");
            tableCreateSQL.appendLine("id VARCHAR(512) PRIMARY KEY, ");
            for (int i = 0; i < model.getColumns().size(); ++i) {
                ModelColumn column = (ModelColumn)model.getColumns().get(i);
                ColumnName name = column.getColumnName();
                tableCreateSQL.appendLine(name.getStorageName() + " " + this.getColumnType(column) + (i != model.getColumns().size() - 1 ? "," : ""));
            }
            tableCreateSQL.appendLine(")");
            if (log.isDebugEnabled()) {
                log.debug("creating table: " + tableCreateSQL.toStringInNewLine());
            }
            jdbcHikariCPClient.execute(connection, tableCreateSQL.toString());
            this.createTableIndexes(jdbcHikariCPClient, connection, model);
        }
        catch (SQLException | JDBCClientException e) {
            throw new StorageException(e.getMessage(), e);
        }
    }

    protected String getColumnType(ModelColumn column) {
        Class type = column.getType();
        if (Integer.class.equals((Object)type) || Integer.TYPE.equals(type) || NodeType.class.equals((Object)type)) {
            return "INT";
        }
        if (Long.class.equals((Object)type) || Long.TYPE.equals(type)) {
            return "BIGINT";
        }
        if (Double.class.equals((Object)type) || Double.TYPE.equals(type)) {
            return "DOUBLE";
        }
        if (String.class.equals((Object)type)) {
            return "VARCHAR(" + column.getLength() + ")";
        }
        if (StorageDataComplexObject.class.isAssignableFrom(type)) {
            return "VARCHAR(20000)";
        }
        if (byte[].class.equals((Object)type)) {
            return "MEDIUMTEXT";
        }
        if (JsonObject.class.equals((Object)type)) {
            return "VARCHAR(" + column.getLength() + ")";
        }
        throw new IllegalArgumentException("Unsupported data type: " + type.getName());
    }

    protected void createTableIndexes(JDBCHikariCPClient client, Connection connection, Model model) throws JDBCClientException {
    }

    protected void createIndex(JDBCHikariCPClient client, Connection connection, Model model, SQLBuilder indexSQL) throws JDBCClientException {
        if (log.isDebugEnabled()) {
            log.debug("create index for table {}, sql: {} ", (Object)model.getName(), (Object)indexSQL.toStringInNewLine());
        }
        client.execute(connection, indexSQL.toString());
    }
}

