/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao;

import org.apache.skywalking.oap.server.core.analysis.config.NoneStream;
import org.apache.skywalking.oap.server.core.analysis.management.ManagementData;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.analysis.record.Record;
import org.apache.skywalking.oap.server.core.storage.IManagementDAO;
import org.apache.skywalking.oap.server.core.storage.IMetricsDAO;
import org.apache.skywalking.oap.server.core.storage.INoneStreamDAO;
import org.apache.skywalking.oap.server.core.storage.IRecordDAO;
import org.apache.skywalking.oap.server.core.storage.StorageBuilder;
import org.apache.skywalking.oap.server.core.storage.StorageDAO;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCHikariCPClient;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2ManagementDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2MetricsDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2NoneStreamDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2RecordDAO;

public class H2StorageDAO
implements StorageDAO {
    private JDBCHikariCPClient h2Client;

    public H2StorageDAO(JDBCHikariCPClient h2Client) {
        this.h2Client = h2Client;
    }

    public IMetricsDAO newMetricsDao(StorageBuilder<Metrics> storageBuilder) {
        return new H2MetricsDAO(this.h2Client, storageBuilder);
    }

    public IRecordDAO newRecordDao(StorageBuilder<Record> storageBuilder) {
        return new H2RecordDAO(this.h2Client, storageBuilder);
    }

    public INoneStreamDAO newNoneStreamDao(StorageBuilder<NoneStream> storageBuilder) {
        return new H2NoneStreamDAO(this.h2Client, storageBuilder);
    }

    public IManagementDAO newManagementDao(StorageBuilder<ManagementData> storageBuilder) {
        return new H2ManagementDAO(this.h2Client, storageBuilder);
    }
}

