/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.skywalking.oap.server.core.analysis.metrics.DataTable;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.input.MetricsCondition;
import org.apache.skywalking.oap.server.core.query.sql.Function;
import org.apache.skywalking.oap.server.core.query.type.HeatMap;
import org.apache.skywalking.oap.server.core.query.type.IntValues;
import org.apache.skywalking.oap.server.core.query.type.KVInt;
import org.apache.skywalking.oap.server.core.query.type.MetricsValues;
import org.apache.skywalking.oap.server.core.storage.annotation.ValueColumnMetadata;
import org.apache.skywalking.oap.server.core.storage.query.IMetricsQueryDAO;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCHikariCPClient;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2SQLExecutor;

public class H2MetricsQueryDAO
extends H2SQLExecutor
implements IMetricsQueryDAO {
    private JDBCHikariCPClient h2Client;

    public H2MetricsQueryDAO(JDBCHikariCPClient h2Client) {
        this.h2Client = h2Client;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int readMetricsValue(MetricsCondition condition, String valueColumnName, Duration duration) throws IOException {
        String op;
        Function function = ValueColumnMetadata.INSTANCE.getValueFunction(condition.getName());
        switch (function) {
            case Avg: {
                op = "avg";
                break;
            }
            default: {
                op = "sum";
            }
        }
        StringBuilder sql = new StringBuilder("select entity_id id, " + op + "(" + valueColumnName + ") value from " + condition.getName() + " where ");
        String entityId = condition.getEntity().buildId();
        ArrayList<Object> parameters = new ArrayList<Object>();
        if (entityId != null) {
            sql.append("entity_id = ? and ");
            parameters.add(entityId);
        }
        sql.append("time_bucket>= ? and time_bucket<=? group by entity_id");
        parameters.add(duration.getStartTimeBucket());
        parameters.add(duration.getEndTimeBucket());
        try (Connection connection = this.h2Client.getConnection();
             ResultSet resultSet = this.h2Client.executeQuery(connection, sql.toString(), parameters.toArray(new Object[0]));){
            if (!resultSet.next()) return ValueColumnMetadata.INSTANCE.getDefaultValue(condition.getName());
            int n = resultSet.getInt("value");
            return n;
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    public MetricsValues readMetricsValues(MetricsCondition condition, String valueColumnName, Duration duration) throws IOException {
        List pointOfTimes = duration.assembleDurationPoints();
        ArrayList ids = new ArrayList(pointOfTimes.size());
        pointOfTimes.forEach(pointOfTime -> ids.add(pointOfTime.id(condition.getEntity().buildId())));
        StringBuilder sql = new StringBuilder("select id, " + valueColumnName + " from " + condition.getName() + " where id in (");
        ArrayList parameters = new ArrayList();
        for (int i = 0; i < ids.size(); ++i) {
            if (i == 0) {
                sql.append("?");
            } else {
                sql.append(",?");
            }
            parameters.add(ids.get(i));
        }
        sql.append(")");
        MetricsValues metricsValues = new MetricsValues();
        IntValues intValues = metricsValues.getValues();
        try (Connection connection = this.h2Client.getConnection();
             ResultSet resultSet = this.h2Client.executeQuery(connection, sql.toString(), parameters.toArray(new Object[0]));){
            while (resultSet.next()) {
                KVInt kv = new KVInt();
                kv.setId(resultSet.getString("id"));
                kv.setValue(resultSet.getLong(valueColumnName));
                intValues.addKVInt(kv);
            }
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
        metricsValues.setValues(IMetricsQueryDAO.Util.sortValues((IntValues)intValues, ids, (int)ValueColumnMetadata.INSTANCE.getDefaultValue(condition.getName())));
        return metricsValues;
    }

    public List<MetricsValues> readLabeledMetricsValues(MetricsCondition condition, String valueColumnName, List<String> labels, Duration duration) throws IOException {
        List pointOfTimes = duration.assembleDurationPoints();
        ArrayList ids = new ArrayList(pointOfTimes.size());
        pointOfTimes.forEach(pointOfTime -> ids.add(pointOfTime.id(condition.getEntity().buildId())));
        StringBuilder sql = new StringBuilder("select id, " + valueColumnName + " from " + condition.getName() + " where id in (");
        ArrayList parameters = new ArrayList();
        for (int i = 0; i < ids.size(); ++i) {
            if (i == 0) {
                sql.append("?");
            } else {
                sql.append(",?");
            }
            parameters.add(ids.get(i));
        }
        sql.append(")");
        HashMap labeledValues = new HashMap(labels.size());
        labels.forEach(label -> {
            MetricsValues labelValue = new MetricsValues();
            labelValue.setLabel(label);
            labeledValues.put(label, labelValue);
        });
        int defaultValue = ValueColumnMetadata.INSTANCE.getDefaultValue(condition.getName());
        try (Connection connection = this.h2Client.getConnection();
             ResultSet resultSet = this.h2Client.executeQuery(connection, sql.toString(), parameters.toArray(new Object[0]));){
            while (resultSet.next()) {
                String id = resultSet.getString("id");
                DataTable multipleValues = new DataTable(5);
                multipleValues.toObject(resultSet.getString(valueColumnName));
                labels.forEach(label -> {
                    Long data = multipleValues.get(label);
                    if (data == null) {
                        data = defaultValue;
                    }
                    IntValues values = ((MetricsValues)labeledValues.get(label)).getValues();
                    KVInt kv = new KVInt();
                    kv.setId(id);
                    kv.setValue(data.longValue());
                    values.addKVInt(kv);
                });
            }
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
        return IMetricsQueryDAO.Util.sortValues(new ArrayList(labeledValues.values()), ids, (int)defaultValue);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HeatMap readHeatMap(MetricsCondition condition, String valueColumnName, Duration duration) throws IOException {
        List pointOfTimes = duration.assembleDurationPoints();
        ArrayList ids = new ArrayList(pointOfTimes.size());
        pointOfTimes.forEach(pointOfTime -> ids.add(pointOfTime.id(condition.getEntity().buildId())));
        StringBuilder sql = new StringBuilder("select id, " + valueColumnName + " dataset, id from " + condition.getName() + " where id in (");
        ArrayList parameters = new ArrayList();
        for (int i = 0; i < ids.size(); ++i) {
            if (i == 0) {
                sql.append("?");
            } else {
                sql.append(",?");
            }
            parameters.add(ids.get(i));
        }
        sql.append(")");
        int defaultValue = ValueColumnMetadata.INSTANCE.getDefaultValue(condition.getName());
        try (Connection connection = this.h2Client.getConnection();){
            HeatMap heatMap = new HeatMap();
            try (ResultSet resultSet = this.h2Client.executeQuery(connection, sql.toString(), parameters.toArray(new Object[0]));){
                while (resultSet.next()) {
                    heatMap.buildColumn(resultSet.getString("id"), resultSet.getString("dataset"), defaultValue);
                }
            }
            heatMap.fixMissingColumns(ids, defaultValue);
            HeatMap heatMap2 = heatMap;
            return heatMap2;
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }
}

