/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao;

import com.google.common.base.Strings;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.skywalking.apm.util.StringUtil;
import org.apache.skywalking.oap.server.core.query.type.ContentType;
import org.apache.skywalking.oap.server.core.query.type.Log;
import org.apache.skywalking.oap.server.core.query.type.LogState;
import org.apache.skywalking.oap.server.core.query.type.Logs;
import org.apache.skywalking.oap.server.core.query.type.Pagination;
import org.apache.skywalking.oap.server.core.storage.query.ILogQueryDAO;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCHikariCPClient;
import org.apache.skywalking.oap.server.library.util.BooleanUtils;

public class H2LogQueryDAO
implements ILogQueryDAO {
    private JDBCHikariCPClient h2Client;

    public H2LogQueryDAO(JDBCHikariCPClient h2Client) {
        this.h2Client = h2Client;
    }

    public Logs queryLogs(String metricName, int serviceId, int serviceInstanceId, String endpointId, String traceId, LogState state, String stateCode, Pagination paging, int from, int limit, long startSecondTB, long endSecondTB) throws IOException {
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> parameters = new ArrayList<Object>(10);
        sql.append("from ").append(metricName).append(" where ");
        sql.append(" 1=1 ");
        if (startSecondTB != 0L && endSecondTB != 0L) {
            sql.append(" and ").append("time_bucket").append(" >= ?");
            parameters.add(startSecondTB);
            sql.append(" and ").append("time_bucket").append(" <= ?");
            parameters.add(endSecondTB);
        }
        if (serviceId != 0) {
            sql.append(" and ").append("service_id").append(" = ?");
            parameters.add(serviceId);
        }
        if (serviceInstanceId != 0) {
            sql.append(" and ").append("service_instance_id").append(" = ?");
            parameters.add(serviceInstanceId);
        }
        if (StringUtil.isNotEmpty((String)endpointId)) {
            sql.append(" and ").append("endpoint_id").append(" = ?");
            parameters.add(endpointId);
        }
        if (!Strings.isNullOrEmpty((String)stateCode)) {
            sql.append(" and ").append("status_code").append(" = ?");
            parameters.add(stateCode);
        }
        if (!Strings.isNullOrEmpty((String)traceId)) {
            sql.append(" and ").append("trace_id").append(" = ?");
            parameters.add(traceId);
        }
        if (LogState.ERROR.equals((Object)state)) {
            sql.append(" and ").append("is_error").append(" = ?");
            parameters.add(BooleanUtils.booleanToValue((Boolean)true));
        } else if (LogState.SUCCESS.equals((Object)state)) {
            sql.append(" and ").append("is_error").append(" = ?");
            parameters.add(BooleanUtils.booleanToValue((Boolean)false));
        }
        Logs logs = new Logs();
        try (Connection connection = this.h2Client.getConnection();){
            try (ResultSet resultSet = this.h2Client.executeQuery(connection, this.buildCountStatement(sql.toString()), parameters.toArray(new Object[0]));){
                while (resultSet.next()) {
                    logs.setTotal(resultSet.getInt("total"));
                }
            }
            this.buildLimit(sql, from, limit);
            resultSet = this.h2Client.executeQuery(connection, "select * " + sql.toString(), parameters.toArray(new Object[0]));
            var21_22 = null;
            try {
                while (resultSet.next()) {
                    Log log = new Log();
                    log.setServiceId(resultSet.getString("service_id"));
                    log.setServiceInstanceId(resultSet.getString("service_instance_id"));
                    log.setEndpointId(resultSet.getString("endpoint_id"));
                    log.setEndpointName(resultSet.getString("endpoint_name"));
                    log.setTraceId(resultSet.getString("trace_id"));
                    log.setTimestamp(resultSet.getString("timestamp"));
                    log.setStatusCode(resultSet.getString("status_code"));
                    log.setContentType(ContentType.instanceOf((int)resultSet.getInt("content_type")));
                    log.setContent(resultSet.getString("content"));
                    logs.getLogs().add(log);
                }
            }
            catch (Throwable throwable) {
                var21_22 = throwable;
                throw throwable;
            }
            finally {
                if (resultSet != null) {
                    if (var21_22 != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable) {
                            var21_22.addSuppressed(throwable);
                        }
                    } else {
                        resultSet.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
        return logs;
    }

    protected String buildCountStatement(String sql) {
        return "select count(1) total from (select 1 " + sql + " )";
    }

    protected void buildLimit(StringBuilder sql, int from, int limit) {
        sql.append(" LIMIT ").append(limit);
        sql.append(" OFFSET ").append(from);
    }
}

