/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.Callable;
import lombok.Generated;
import org.apache.skywalking.apm.commons.datacarrier.DataCarrier;
import org.apache.skywalking.apm.commons.datacarrier.consumer.BulkConsumePool;
import org.apache.skywalking.apm.commons.datacarrier.consumer.ConsumerPoolFactory;
import org.apache.skywalking.apm.commons.datacarrier.consumer.IConsumer;
import org.apache.skywalking.oap.server.core.UnexpectedException;
import org.apache.skywalking.oap.server.core.storage.IBatchDAO;
import org.apache.skywalking.oap.server.library.client.jdbc.JDBCClientException;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCHikariCPClient;
import org.apache.skywalking.oap.server.library.client.request.InsertRequest;
import org.apache.skywalking.oap.server.library.client.request.PrepareRequest;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.SQLExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class H2BatchDAO
implements IBatchDAO {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(H2BatchDAO.class);
    private JDBCHikariCPClient h2Client;
    private final DataCarrier<PrepareRequest> dataCarrier;

    public H2BatchDAO(JDBCHikariCPClient h2Client) {
        this.h2Client = h2Client;
        String name = "H2_ASYNCHRONOUS_BATCH_PERSISTENT";
        BulkConsumePool.Creator creator = new BulkConsumePool.Creator(name, 1, 20L);
        try {
            ConsumerPoolFactory.INSTANCE.createIfAbsent(name, (Callable)creator);
        }
        catch (Exception e) {
            throw new UnexpectedException(e.getMessage(), e);
        }
        this.dataCarrier = new DataCarrier(1, 10000);
        this.dataCarrier.consume(ConsumerPoolFactory.INSTANCE.get(name), (IConsumer)new H2BatchConsumer(this));
    }

    public void synchronous(List<PrepareRequest> prepareRequests) {
        if (CollectionUtils.isEmpty(prepareRequests)) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("batch sql statements execute, data size: {}", (Object)prepareRequests.size());
        }
        try (Connection connection = this.h2Client.getConnection();){
            for (PrepareRequest prepareRequest : prepareRequests) {
                try {
                    SQLExecutor sqlExecutor = (SQLExecutor)prepareRequest;
                    sqlExecutor.invoke(connection);
                }
                catch (SQLException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        catch (SQLException | JDBCClientException e) {
            log.error(e.getMessage(), e);
        }
    }

    public void asynchronous(InsertRequest insertRequest) {
        this.dataCarrier.produce((Object)insertRequest);
    }

    private class H2BatchConsumer
    implements IConsumer<PrepareRequest> {
        private final H2BatchDAO h2BatchDAO;

        private H2BatchConsumer(H2BatchDAO h2BatchDAO2) {
            this.h2BatchDAO = h2BatchDAO2;
        }

        public void init() {
        }

        public void consume(List<PrepareRequest> prepareRequests) {
            this.h2BatchDAO.synchronous(prepareRequests);
        }

        public void onError(List<PrepareRequest> prepareRequests, Throwable t) {
            log.error(t.getMessage(), t);
        }

        public void onExit() {
        }
    }
}

