/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.skywalking.oap.server.core.query.enumeration.Scope;
import org.apache.skywalking.oap.server.core.query.type.AlarmMessage;
import org.apache.skywalking.oap.server.core.query.type.Alarms;
import org.apache.skywalking.oap.server.core.storage.query.IAlarmQueryDAO;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCHikariCPClient;
import org.elasticsearch.common.Strings;

public class H2AlarmQueryDAO
implements IAlarmQueryDAO {
    private JDBCHikariCPClient client;

    public H2AlarmQueryDAO(JDBCHikariCPClient client) {
        this.client = client;
    }

    public Alarms getAlarm(Integer scopeId, String keyword, int limit, int from, long startTB, long endTB) throws IOException {
        StringBuilder sql = new StringBuilder();
        ArrayList<Number> parameters = new ArrayList<Number>(10);
        sql.append("from ").append("alarm_record").append(" where ");
        sql.append(" 1=1 ");
        if (Objects.nonNull(scopeId)) {
            sql.append(" and ").append("scope").append(" = ?");
            parameters.add(scopeId);
        }
        if (startTB != 0L && endTB != 0L) {
            sql.append(" and ").append("time_bucket").append(" >= ?");
            parameters.add(startTB);
            sql.append(" and ").append("time_bucket").append(" <= ?");
            parameters.add(endTB);
        }
        if (!Strings.isNullOrEmpty((String)keyword)) {
            sql.append(" and ").append("alarm_message").append(" like '%").append(keyword).append("%' ");
        }
        sql.append(" order by ").append("start_time").append(" desc ");
        Alarms alarms = new Alarms();
        try (Connection connection = this.client.getConnection();){
            try (ResultSet resultSet = this.client.executeQuery(connection, "select count(1) total from (select 1 " + sql.toString() + " )", parameters.toArray(new Object[0]));){
                while (resultSet.next()) {
                    alarms.setTotal(resultSet.getInt("total"));
                }
            }
            this.buildLimit(sql, from, limit);
            resultSet = this.client.executeQuery(connection, "select * " + sql.toString(), parameters.toArray(new Object[0]));
            var15_16 = null;
            try {
                while (resultSet.next()) {
                    AlarmMessage message = new AlarmMessage();
                    message.setId(resultSet.getString("id0"));
                    message.setMessage(resultSet.getString("alarm_message"));
                    message.setStartTime(Long.valueOf(resultSet.getLong("start_time")));
                    message.setScope(Scope.Finder.valueOf((int)resultSet.getInt("scope")));
                    message.setScopeId(resultSet.getInt("scope"));
                    alarms.getMsgs().add(message);
                }
            }
            catch (Throwable throwable) {
                var15_16 = throwable;
                throw throwable;
            }
            finally {
                if (resultSet != null) {
                    if (var15_16 != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable) {
                            var15_16.addSuppressed(throwable);
                        }
                    } else {
                        resultSet.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
        return alarms;
    }

    protected void buildLimit(StringBuilder sql, int from, int limit) {
        sql.append(" LIMIT ").append(limit);
        sql.append(" OFFSET ").append(from);
    }
}

