/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao;

import com.google.common.base.Strings;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import org.apache.skywalking.oap.server.core.analysis.manual.segment.SegmentRecord;
import org.apache.skywalking.oap.server.core.query.entity.BasicTrace;
import org.apache.skywalking.oap.server.core.query.entity.QueryOrder;
import org.apache.skywalking.oap.server.core.query.entity.Span;
import org.apache.skywalking.oap.server.core.query.entity.TraceBrief;
import org.apache.skywalking.oap.server.core.query.entity.TraceState;
import org.apache.skywalking.oap.server.core.storage.query.ITraceQueryDAO;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCHikariCPClient;
import org.apache.skywalking.oap.server.library.util.BooleanUtils;
import org.elasticsearch.search.sort.SortOrder;

public class H2TraceQueryDAO
implements ITraceQueryDAO {
    private JDBCHikariCPClient h2Client;

    public H2TraceQueryDAO(JDBCHikariCPClient h2Client) {
        this.h2Client = h2Client;
    }

    public TraceBrief queryBasicTraces(long startSecondTB, long endSecondTB, long minDuration, long maxDuration, String endpointName, int serviceId, int serviceInstanceId, int endpointId, String traceId, int limit, int from, TraceState traceState, QueryOrder queryOrder) throws IOException {
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> parameters = new ArrayList<Object>(10);
        sql.append("from ").append("segment").append(" where ");
        sql.append(" 1=1 ");
        if (startSecondTB != 0L && endSecondTB != 0L) {
            sql.append(" and ").append("time_bucket").append(" >= ?");
            parameters.add(startSecondTB);
            sql.append(" and ").append("time_bucket").append(" <= ?");
            parameters.add(endSecondTB);
        }
        if (minDuration != 0L || maxDuration != 0L) {
            if (minDuration != 0L) {
                sql.append(" and ").append("latency").append(" >= ?");
                parameters.add(minDuration);
            }
            if (maxDuration != 0L) {
                sql.append(" and ").append("latency").append(" <= ?");
                parameters.add(maxDuration);
            }
        }
        if (!Strings.isNullOrEmpty((String)endpointName)) {
            sql.append(" and ").append("endpoint_name").append(" like '%" + endpointName + "%'");
        }
        if (serviceId != 0) {
            sql.append(" and ").append("service_id").append(" = ?");
            parameters.add(serviceId);
        }
        if (serviceInstanceId != 0) {
            sql.append(" and ").append("service_instance_id").append(" = ?");
            parameters.add(serviceInstanceId);
        }
        if (endpointId != 0) {
            sql.append(" and ").append("endpoint_id").append(" = ?");
            parameters.add(endpointId);
        }
        if (!Strings.isNullOrEmpty((String)traceId)) {
            sql.append(" and ").append("trace_id").append(" = ?");
            parameters.add(traceId);
        }
        switch (traceState) {
            case ERROR: {
                sql.append(" and ").append("is_error").append(" = ").append(1);
                break;
            }
            case SUCCESS: {
                sql.append(" and ").append("is_error").append(" = ").append(0);
            }
        }
        switch (queryOrder) {
            case BY_START_TIME: {
                sql.append(" order by ").append("start_time").append(" ").append(SortOrder.DESC);
                break;
            }
            case BY_DURATION: {
                sql.append(" order by ").append("latency").append(" ").append(SortOrder.DESC);
            }
        }
        TraceBrief traceBrief = new TraceBrief();
        try (Connection connection = this.h2Client.getConnection();){
            try (ResultSet resultSet = this.h2Client.executeQuery(connection, this.buildCountStatement(sql.toString()), parameters.toArray(new Object[0]));){
                while (resultSet.next()) {
                    traceBrief.setTotal(resultSet.getInt("total"));
                }
            }
            this.buildLimit(sql, from, limit);
            resultSet = this.h2Client.executeQuery(connection, "select * " + sql.toString(), parameters.toArray(new Object[0]));
            var24_23 = null;
            try {
                while (resultSet.next()) {
                    BasicTrace basicTrace = new BasicTrace();
                    basicTrace.setSegmentId(resultSet.getString("segment_id"));
                    basicTrace.setStart(resultSet.getString("start_time"));
                    basicTrace.getEndpointNames().add(resultSet.getString("endpoint_name"));
                    basicTrace.setDuration(resultSet.getInt("latency"));
                    basicTrace.setError(BooleanUtils.valueToBoolean((int)resultSet.getInt("is_error")));
                    String traceIds = resultSet.getString("trace_id");
                    basicTrace.getTraceIds().add(traceIds);
                    traceBrief.getTraces().add(basicTrace);
                }
            }
            catch (Throwable throwable) {
                var24_23 = throwable;
                throw throwable;
            }
            finally {
                if (resultSet != null) {
                    if (var24_23 != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable) {
                            var24_23.addSuppressed(throwable);
                        }
                    } else {
                        resultSet.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
        return traceBrief;
    }

    protected String buildCountStatement(String sql) {
        return "select count(1) total from (select 1 " + sql + " )";
    }

    protected void buildLimit(StringBuilder sql, int from, int limit) {
        sql.append(" LIMIT ").append(limit);
        sql.append(" OFFSET ").append(from);
    }

    public List<SegmentRecord> queryByTraceId(String traceId) throws IOException {
        ArrayList<SegmentRecord> segmentRecords = new ArrayList<SegmentRecord>();
        try (Connection connection = this.h2Client.getConnection();
             ResultSet resultSet = this.h2Client.executeQuery(connection, "select * from segment where trace_id = ?", new Object[]{traceId});){
            while (resultSet.next()) {
                SegmentRecord segmentRecord = new SegmentRecord();
                segmentRecord.setSegmentId(resultSet.getString("segment_id"));
                segmentRecord.setTraceId(resultSet.getString("trace_id"));
                segmentRecord.setServiceId(resultSet.getInt("service_id"));
                segmentRecord.setEndpointName(resultSet.getString("endpoint_name"));
                segmentRecord.setStartTime(resultSet.getLong("start_time"));
                segmentRecord.setEndTime(resultSet.getLong("end_time"));
                segmentRecord.setLatency(resultSet.getInt("latency"));
                segmentRecord.setIsError(resultSet.getInt("is_error"));
                String dataBinaryBase64 = resultSet.getString("data_binary");
                if (!Strings.isNullOrEmpty((String)dataBinaryBase64)) {
                    segmentRecord.setDataBinary(Base64.getDecoder().decode(dataBinaryBase64));
                }
                segmentRecord.setVersion(resultSet.getInt("version"));
                segmentRecords.add(segmentRecord);
            }
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
        return segmentRecords;
    }

    public List<Span> doFlexibleTraceQuery(String traceId) {
        return Collections.emptyList();
    }
}

