/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.skywalking.oap.server.core.register.ServiceInventory;
import org.apache.skywalking.oap.server.core.storage.StorageBuilder;
import org.apache.skywalking.oap.server.core.storage.cache.IServiceInventoryCacheDAO;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCHikariCPClient;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2SQLExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class H2ServiceInventoryCacheDAO
extends H2SQLExecutor
implements IServiceInventoryCacheDAO {
    private static final Logger logger = LoggerFactory.getLogger(H2ServiceInventoryCacheDAO.class);
    private JDBCHikariCPClient h2Client;

    public H2ServiceInventoryCacheDAO(JDBCHikariCPClient h2Client) {
        this.h2Client = h2Client;
    }

    public int getServiceId(String serviceName) {
        String id = ServiceInventory.buildId((String)serviceName);
        return this.getEntityIDByID(this.h2Client, "sequence", "service_inventory", id);
    }

    public int getServiceId(int addressId) {
        String id = ServiceInventory.buildId((int)addressId);
        return this.getEntityIDByID(this.h2Client, "sequence", "service_inventory", id);
    }

    public ServiceInventory get(int serviceId) {
        try {
            return (ServiceInventory)this.getByColumn(this.h2Client, "service_inventory", "sequence", serviceId, (StorageBuilder)new ServiceInventory.Builder());
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public List<ServiceInventory> loadLastUpdate(long lastUpdateTime) {
        ArrayList<ServiceInventory> serviceInventories = new ArrayList<ServiceInventory>();
        try {
            StringBuilder sql = new StringBuilder("select * from ");
            sql.append("service_inventory");
            sql.append(" where ").append("is_address").append("=? ");
            sql.append(" and ").append("last_update_time").append(">?");
            try (Connection connection = this.h2Client.getConnection();
                 ResultSet resultSet = this.h2Client.executeQuery(connection, sql.toString(), new Object[]{1, lastUpdateTime});){
                ServiceInventory serviceInventory;
                do {
                    if ((serviceInventory = (ServiceInventory)this.toStorageData(resultSet, "service_inventory", (StorageBuilder)new ServiceInventory.Builder())) == null) continue;
                    serviceInventories.add(serviceInventory);
                } while (serviceInventory != null);
            }
            catch (SQLException e) {
                throw new IOException(e);
            }
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
        return serviceInventories;
    }
}

