/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.skywalking.oap.server.core.register.RegisterSource;
import org.apache.skywalking.oap.server.core.storage.IRegisterLockDAO;
import org.apache.skywalking.oap.server.library.client.jdbc.JDBCClientException;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCHikariCPClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class H2RegisterLockDAO
implements IRegisterLockDAO {
    private static final Logger logger = LoggerFactory.getLogger(H2RegisterLockDAO.class);
    private JDBCHikariCPClient h2Client;

    public H2RegisterLockDAO(JDBCHikariCPClient h2Client) {
        this.h2Client = h2Client;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getId(int scopeId, RegisterSource registerSource) {
        try (Connection connection = this.h2Client.getTransactionConnection();){
            ResultSet resultSet = this.h2Client.executeQuery(connection, "select sequence from register_lock where id = " + scopeId + " for update", new Object[0]);
            if (!resultSet.next()) return 0;
            int sequence = resultSet.getInt("sequence");
            this.h2Client.execute(connection, "update register_lock set sequence = " + ++sequence + " where id = " + scopeId);
            connection.commit();
            int n = sequence;
            return n;
        }
        catch (SQLException | JDBCClientException e) {
            logger.error("try inventory register lock for scope id={} name={} failure.", (Object)scopeId, (Object)scopeId);
            logger.error("tryLock error", e);
            return 0;
        }
    }
}

