/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.skywalking.oap.server.core.register.RegisterSource;
import org.apache.skywalking.oap.server.core.storage.IRegisterDAO;
import org.apache.skywalking.oap.server.core.storage.StorageBuilder;
import org.apache.skywalking.oap.server.core.storage.StorageData;
import org.apache.skywalking.oap.server.library.client.jdbc.JDBCClientException;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCHikariCPClient;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2SQLExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class H2RegisterDAO
extends H2SQLExecutor
implements IRegisterDAO {
    private static final Logger logger = LoggerFactory.getLogger(H2RegisterDAO.class);
    private final JDBCHikariCPClient h2Client;
    private final StorageBuilder<RegisterSource> storageBuilder;

    public H2RegisterDAO(JDBCHikariCPClient h2Client, StorageBuilder<RegisterSource> storageBuilder) {
        this.h2Client = h2Client;
        this.storageBuilder = storageBuilder;
    }

    public RegisterSource get(String modelName, String id) throws IOException {
        return (RegisterSource)this.getByID(this.h2Client, modelName, id, this.storageBuilder);
    }

    public void forceInsert(String modelName, RegisterSource source) throws IOException {
        try (Connection connection = this.h2Client.getConnection();){
            this.getInsertExecutor(modelName, (StorageData)source, this.storageBuilder).invoke(connection);
        }
        catch (SQLException | JDBCClientException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public void forceUpdate(String modelName, RegisterSource source) throws IOException {
        try (Connection connection = this.h2Client.getConnection();){
            this.getUpdateExecutor(modelName, (StorageData)source, this.storageBuilder).invoke(connection);
        }
        catch (SQLException | JDBCClientException e) {
            throw new IOException(e.getMessage(), e);
        }
    }
}

