/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.skywalking.oap.server.core.register.NetworkAddressInventory;
import org.apache.skywalking.oap.server.core.storage.StorageBuilder;
import org.apache.skywalking.oap.server.core.storage.cache.INetworkAddressInventoryCacheDAO;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCHikariCPClient;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2SQLExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class H2NetworkAddressInventoryCacheDAO
extends H2SQLExecutor
implements INetworkAddressInventoryCacheDAO {
    private static final Logger logger = LoggerFactory.getLogger(H2NetworkAddressInventoryCacheDAO.class);
    private JDBCHikariCPClient h2Client;

    public H2NetworkAddressInventoryCacheDAO(JDBCHikariCPClient h2Client) {
        this.h2Client = h2Client;
    }

    public int getAddressId(String networkAddress) {
        String id = NetworkAddressInventory.buildId((String)networkAddress);
        return this.getEntityIDByID(this.h2Client, "sequence", "network_address_inventory", id);
    }

    public NetworkAddressInventory get(int addressId) {
        try {
            return (NetworkAddressInventory)this.getByColumn(this.h2Client, "network_address_inventory", "sequence", addressId, (StorageBuilder)new NetworkAddressInventory.Builder());
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public List<NetworkAddressInventory> loadLastUpdate(long lastUpdateTime) {
        ArrayList<NetworkAddressInventory> addressInventories = new ArrayList<NetworkAddressInventory>();
        try {
            StringBuilder sql = new StringBuilder("select * from ");
            sql.append("network_address_inventory");
            sql.append(" where ").append("last_update_time").append(">?");
            try (Connection connection = this.h2Client.getConnection();
                 ResultSet resultSet = this.h2Client.executeQuery(connection, sql.toString(), new Object[]{lastUpdateTime});){
                NetworkAddressInventory addressInventory;
                do {
                    if ((addressInventory = (NetworkAddressInventory)this.toStorageData(resultSet, "network_address_inventory", (StorageBuilder)new NetworkAddressInventory.Builder())) == null) continue;
                    addressInventories.add(addressInventory);
                } while (addressInventory != null);
            }
            catch (SQLException e) {
                throw new IOException(e);
            }
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
        return addressInventories;
    }
}

