/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.skywalking.oap.server.core.analysis.Downsampling;
import org.apache.skywalking.oap.server.core.query.entity.Order;
import org.apache.skywalking.oap.server.core.query.entity.TopNEntity;
import org.apache.skywalking.oap.server.core.storage.model.ModelName;
import org.apache.skywalking.oap.server.core.storage.query.IAggregationQueryDAO;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCHikariCPClient;

public class H2AggregationQueryDAO
implements IAggregationQueryDAO {
    private JDBCHikariCPClient h2Client;

    public H2AggregationQueryDAO(JDBCHikariCPClient h2Client) {
        this.h2Client = h2Client;
    }

    public List<TopNEntity> getServiceTopN(String indName, String valueCName, int topN, Downsampling downsampling, long startTB, long endTB, Order order) throws IOException {
        return this.topNQuery(indName, valueCName, topN, downsampling, startTB, endTB, order, null);
    }

    public List<TopNEntity> getAllServiceInstanceTopN(String indName, String valueCName, int topN, Downsampling downsampling, long startTB, long endTB, Order order) throws IOException {
        return this.topNQuery(indName, valueCName, topN, downsampling, startTB, endTB, order, null);
    }

    public List<TopNEntity> getServiceInstanceTopN(int serviceId, String indName, String valueCName, int topN, Downsampling downsampling, long startTB, long endTB, Order order) throws IOException {
        return this.topNQuery(indName, valueCName, topN, downsampling, startTB, endTB, order, (sql, conditions) -> {
            sql.append(" and ").append("service_id").append("=?");
            conditions.add(serviceId);
        });
    }

    public List<TopNEntity> getAllEndpointTopN(String indName, String valueCName, int topN, Downsampling downsampling, long startTB, long endTB, Order order) throws IOException {
        return this.topNQuery(indName, valueCName, topN, downsampling, startTB, endTB, order, null);
    }

    public List<TopNEntity> getEndpointTopN(int serviceId, String indName, String valueCName, int topN, Downsampling downsampling, long startTB, long endTB, Order order) throws IOException {
        return this.topNQuery(indName, valueCName, topN, downsampling, startTB, endTB, order, (sql, conditions) -> {
            sql.append(" and ").append("service_id").append("=?");
            conditions.add(serviceId);
        });
    }

    public List<TopNEntity> topNQuery(String indName, String valueCName, int topN, Downsampling downsampling, long startTB, long endTB, Order order, AppendCondition appender) throws IOException {
        String indexName = ModelName.build((Downsampling)downsampling, (String)indName);
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> conditions = new ArrayList<Object>(10);
        sql.append("select * from (select avg(").append(valueCName).append(") value,").append("entity_id").append(" from ").append(indexName).append(" where ");
        this.setTimeRangeCondition(sql, conditions, startTB, endTB);
        if (appender != null) {
            appender.append(sql, conditions);
        }
        sql.append(" group by ").append("entity_id");
        sql.append(") order by value ").append(order.equals((Object)Order.ASC) ? "asc" : "desc").append(" limit ").append(topN);
        ArrayList<TopNEntity> topNEntities = new ArrayList<TopNEntity>();
        try (Connection connection = this.h2Client.getConnection();
             ResultSet resultSet = this.h2Client.executeQuery(connection, sql.toString(), conditions.toArray(new Object[0]));){
            while (resultSet.next()) {
                TopNEntity topNEntity = new TopNEntity();
                topNEntity.setId(resultSet.getString("entity_id"));
                topNEntity.setValue(resultSet.getLong("value"));
                topNEntities.add(topNEntity);
            }
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
        return topNEntities;
    }

    protected void setTimeRangeCondition(StringBuilder sql, List<Object> conditions, long startTimestamp, long endTimestamp) {
        sql.append("time_bucket").append(" >= ? and ").append("time_bucket").append(" <= ?");
        conditions.add(startTimestamp);
        conditions.add(endTimestamp);
    }

    protected JDBCHikariCPClient getH2Client() {
        return this.h2Client;
    }

    protected static interface AppendCondition {
        public void append(StringBuilder var1, List<Object> var2);
    }
}

