/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.netcdf;

import java.io.Serializable;
import org.opengis.metadata.citation.Role;
import org.opengis.metadata.spatial.DimensionNameType;

public class AttributeNames {
    public static final String TITLE = "title";
    public static final String SUMMARY = "summary";
    public static final String IDENTIFIER = "id";
    public static final String NAMING_AUTHORITY = "naming_authority";
    public static final String STANDARD_NAME = "standard_name";
    public static final String STANDARD_NAME_VOCABULARY = "standard_name_vocabulary";
    public static final String KEYWORDS = "keywords";
    public static final String VOCABULARY = "keywords_vocabulary";
    public static final String TOPIC_CATEGORY = "topic_category";
    public static final String DATA_TYPE = "cdm_data_type";
    public static final String HISTORY = "history";
    public static final String COMMENT = "comment";
    public static final String METADATA_CREATION = "metadata_creation";
    public static final String DATE_CREATED = "date_created";
    public static final String DATE_MODIFIED = "date_modified";
    public static final String DATE_ISSUED = "date_issued";
    public static final Responsible CREATOR = new Responsible("creator_name", "institution", "creator_url", "creator_email", null, Role.ORIGINATOR);
    public static final Responsible CONTRIBUTOR = new Responsible("contributor_name", null, "contributor_url", "contributor_email", "contributor_role", null);
    public static final Responsible PUBLISHER = new Responsible("publisher_name", null, "publisher_url", "publisher_email", null, Role.PUBLISHER);
    public static final String PROJECT = "project";
    public static final String PURPOSE = "purpose";
    public static final String REFERENCES = "references";
    public static final String PROCESSING_LEVEL = "processing_level";
    public static final String ACKNOWLEDGMENT = "acknowledgment";
    public static final String LICENSE = "license";
    public static final String ACCESS_CONSTRAINT = "acces_constraint";
    public static final String GEOGRAPHIC_IDENTIFIER = "geographic_identifier";
    public static final Dimension LATITUDE = new Dimension(DimensionNameType.ROW, "geospatial_lat_min", "geospatial_lat_max", null, "geospatial_lat_resolution", "geospatial_lat_units", null);
    public static final Dimension LONGITUDE = new Dimension(DimensionNameType.COLUMN, "geospatial_lon_min", "geospatial_lon_max", null, "geospatial_lon_resolution", "geospatial_lon_units", null);
    public static final Dimension VERTICAL = new Dimension(DimensionNameType.VERTICAL, "geospatial_vertical_min", "geospatial_vertical_max", null, "geospatial_vertical_resolution", "geospatial_vertical_units", "geospatial_vertical_positive");
    public static final Dimension TIME = new Dimension(DimensionNameType.TIME, "time_coverage_start", "time_coverage_end", "time_coverage_duration", "time_coverage_resolution", "time_coverage_units", null);
    public static final String FLAG_NAMES = "flag_names";
    public static final String FLAG_MASKS = "flag_masks";
    public static final String FLAG_VALUES = "flag_values";
    public static final String FLAG_MEANINGS = "flag_meanings";

    protected AttributeNames() {
    }

    public static class Dimension
    implements Serializable {
        private static final long serialVersionUID = 5063525623830032591L;
        public final String MINIMUM;
        public final String MAXIMUM;
        public final String SPAN;
        public final String RESOLUTION;
        public final String UNITS;
        public final String POSITIVE;
        public final DimensionNameType DEFAULT_NAME_TYPE;

        public Dimension(DimensionNameType type, String min, String max, String span, String resolution, String units, String positive) {
            this.DEFAULT_NAME_TYPE = type;
            this.MINIMUM = min;
            this.MAXIMUM = max;
            this.SPAN = span;
            this.RESOLUTION = resolution;
            this.UNITS = units;
            this.POSITIVE = positive;
        }
    }

    public static class Responsible
    implements Serializable {
        private static final long serialVersionUID = 2680152633273321012L;
        public final String NAME;
        public final String INSTITUTION;
        public final String URL;
        public final String EMAIL;
        public final String ROLE;
        public final Role DEFAULT_ROLE;

        public Responsible(String name, String institution, String url, String email, String role, Role defaultRole) {
            this.NAME = name;
            this.INSTITUTION = institution;
            this.URL = url;
            this.EMAIL = email;
            this.ROLE = role;
            this.DEFAULT_ROLE = defaultRole;
        }
    }
}

