/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf.ucar;

import java.io.IOException;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import org.apache.sis.internal.netcdf.Decoder;
import org.apache.sis.internal.netcdf.GridGeometry;
import org.apache.sis.internal.netcdf.Variable;
import org.apache.sis.internal.netcdf.ucar.GridGeometryWrapper;
import org.apache.sis.internal.netcdf.ucar.VariableWrapper;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.logging.WarningListeners;
import ucar.nc2.Attribute;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.VariableIF;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.time.Calendar;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateFormatter;
import ucar.nc2.units.DateUnit;
import ucar.nc2.util.CancelTask;

public final class DecoderWrapper
extends Decoder
implements CancelTask {
    private final NetcdfFile file;
    private Group[] groups;
    private transient Variable[] variables;
    private transient GridGeometry[] geometries;

    public DecoderWrapper(WarningListeners<?> listeners, NetcdfFile file) {
        super(listeners);
        this.file = file;
    }

    public DecoderWrapper(WarningListeners<?> listeners, String filename) throws IOException {
        super(listeners);
        this.file = NetcdfDataset.openDataset((String)filename, (boolean)false, (CancelTask)this);
    }

    @Override
    public void setSearchPath(String ... groupNames) {
        Object[] groups = new Group[groupNames.length];
        int count = 0;
        for (String name : groupNames) {
            if (name != null) {
                Group group = this.file.findGroup(name);
                if (group == null) continue;
                groups[count] = group;
            }
            ++count;
        }
        this.groups = (Group[])ArraysExt.resize((Object[])groups, (int)count);
    }

    @Override
    public String[] getSearchPath() {
        String[] path = new String[this.groups.length];
        for (int i = 0; i < path.length; ++i) {
            Group group = this.groups[i];
            if (group == null) continue;
            path[i] = group.getShortName();
        }
        return path;
    }

    private Attribute findAttribute(Group group, String name) {
        return group != null ? group.findAttributeIgnoreCase(name) : this.file.findGlobalAttributeIgnoreCase(name);
    }

    @Override
    public String stringValue(String name) {
        if (name != null) {
            for (Group group : this.groups) {
                String value;
                Attribute attribute = this.findAttribute(group, name);
                if (attribute == null || !attribute.isString() || (value = attribute.getStringValue()) == null || (value = value.trim()).isEmpty()) continue;
                return value;
            }
        }
        return null;
    }

    @Override
    public Number numericValue(String name) {
        if (name != null) {
            for (Group group : this.groups) {
                Attribute attribute = this.findAttribute(group, name);
                if (attribute == null) continue;
                Number value = attribute.getNumericValue();
                if (value != null) {
                    return value;
                }
                String asString = attribute.getStringValue();
                if (asString == null || (asString = asString.trim()).isEmpty()) continue;
                return this.parseNumber(asString);
            }
        }
        return null;
    }

    @Override
    public Date dateValue(String name) {
        if (name != null) {
            for (Group group : this.groups) {
                CalendarDate date;
                String value;
                Attribute attribute = this.findAttribute(group, name);
                if (attribute == null || !attribute.isString() || (value = attribute.getStringValue()) == null || (value = value.trim()).isEmpty()) continue;
                try {
                    date = CalendarDateFormatter.isoStringToCalendarDate((Calendar)Calendar.proleptic_gregorian, (String)value);
                }
                catch (IllegalArgumentException e) {
                    this.listeners.warning(null, (Exception)e);
                    continue;
                }
                return new Date(date.getMillis());
            }
        }
        return null;
    }

    @Override
    public Date[] numberToDate(String symbol, Number ... values) {
        DateUnit unit;
        Date[] dates = new Date[values.length];
        try {
            unit = new DateUnit(symbol);
        }
        catch (Exception e) {
            this.listeners.warning(null, e);
            return dates;
        }
        for (int i = 0; i < values.length; ++i) {
            Number value = values[i];
            if (value == null) continue;
            dates[i] = unit.makeDate(value.doubleValue());
        }
        return dates;
    }

    @Override
    public String getId() {
        return this.file.getId();
    }

    @Override
    public String getTitle() {
        return this.file.getTitle();
    }

    @Override
    public Variable[] getVariables() {
        if (this.variables == null) {
            List dimensions = this.file.getDimensions();
            List all = this.file.getVariables();
            this.variables = new Variable[all != null ? all.size() : 0];
            for (int i = 0; i < this.variables.length; ++i) {
                this.variables[i] = new VariableWrapper((VariableIF)all.get(i), dimensions);
            }
        }
        return this.variables;
    }

    @Override
    public GridGeometry[] getGridGeometries() throws IOException {
        if (this.geometries == null) {
            List systems = null;
            if (this.file instanceof NetcdfDataset) {
                NetcdfDataset ds = (NetcdfDataset)this.file;
                EnumSet<NetcdfDataset.Enhance> mode = EnumSet.copyOf(ds.getEnhanceMode());
                if (mode.add(NetcdfDataset.Enhance.CoordSystems)) {
                    ds.enhance(mode);
                }
                systems = ds.getCoordinateSystems();
            }
            this.geometries = new GridGeometry[systems != null ? systems.size() : 0];
            for (int i = 0; i < this.geometries.length; ++i) {
                this.geometries[i] = new GridGeometryWrapper((CoordinateSystem)systems.get(i));
            }
        }
        return this.geometries;
    }

    public boolean isCancel() {
        return this.canceled;
    }

    public void setProgress(String message, int progress) {
    }

    public void setError(String message) {
        this.listeners.warning(message, null);
    }

    @Override
    public void close() throws IOException {
        this.file.close();
    }

    public String toString() {
        return "UCAR driver: \u201c" + this.file.getLocation() + '\u201d';
    }
}

