/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf.impl;

import java.io.IOException;
import java.util.Map;
import org.apache.sis.internal.netcdf.Variable;
import org.apache.sis.internal.netcdf.impl.Attribute;
import org.apache.sis.internal.netcdf.impl.Dimension;
import org.apache.sis.internal.netcdf.impl.GridGeometryInfo;
import org.apache.sis.internal.storage.ChannelDataInput;
import org.apache.sis.internal.storage.HyperRectangleReader;
import org.apache.sis.internal.storage.Region;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.util.resources.Errors;

final class VariableInfo
extends Variable {
    private static final String[] DESCRIPTION_ATTRIBUTES = new String[]{"long_name", "description", "title", "standard_name"};
    static final int BYTE = 1;
    static final int CHAR = 2;
    static final int SHORT = 3;
    static final int INT = 4;
    static final int FLOAT = 5;
    static final int DOUBLE = 6;
    private static final byte[] NUMBER_TYPES = new byte[]{3, 3, 4, 5, 7, 8};
    private static final byte[] SIZES = new byte[]{1, 1, 2, 4, 4, 8};
    private static final Class<?>[] TYPES = new Class[]{Byte.TYPE, Character.TYPE, Short.TYPE, Integer.TYPE, Float.TYPE, Double.TYPE};
    private final HyperRectangleReader reader;
    private final String name;
    final Dimension[] dimensions;
    private final Dimension[] allDimensions;
    private final Map<String, Attribute> attributes;
    private final int dataType;
    GridGeometryInfo gridGeometry;

    VariableInfo(ChannelDataInput input, String name, Dimension[] dimensions, Dimension[] allDimensions, Map<String, Attribute> attributes, int dataType, int size, long offset) throws DataStoreException {
        this.name = name;
        this.dimensions = dimensions;
        this.allDimensions = allDimensions;
        this.attributes = attributes;
        this.dataType = dataType--;
        this.reader = dataType >= 0 && dataType < NUMBER_TYPES.length ? new HyperRectangleReader(NUMBER_TYPES[dataType], input, offset) : null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        for (String attributeName : DESCRIPTION_ATTRIBUTES) {
            Attribute attribute = this.attributes.get(attributeName);
            if (attribute == null || !(attribute.value instanceof String)) continue;
            return (String)attribute.value;
        }
        return null;
    }

    @Override
    public String getUnitsString() {
        Attribute attribute = this.attributes.get("units");
        if (attribute != null && attribute.value instanceof String) {
            return (String)attribute.value;
        }
        return null;
    }

    @Override
    public Class<?> getDataType() {
        int i = this.dataType - 1;
        return i >= 0 && i < TYPES.length ? TYPES[i] : null;
    }

    static int sizeOf(int datatype) {
        return --datatype >= 0 && datatype < SIZES.length ? SIZES[datatype] : 0;
    }

    @Override
    public boolean isUnsigned() {
        Attribute attribute = this.attributes.get("_Unsigned");
        return attribute != null && attribute.booleanValue();
    }

    @Override
    public boolean isCoordinateSystemAxis() {
        String name = this.name;
        Attribute attribute = this.attributes.get("_CoordinateVariableAlias");
        if (attribute != null && attribute.value instanceof String) {
            name = (String)attribute.value;
        }
        for (Dimension dimension : this.allDimensions) {
            if (!name.equals(dimension.name)) continue;
            return true;
        }
        return false;
    }

    final String getAxisType() {
        Attribute attribute = this.attributes.get("_CoordinateAxisType");
        if (attribute != null && attribute.value instanceof String) {
            return (String)attribute.value;
        }
        return null;
    }

    @Override
    public String[] getGridDimensionNames() {
        String[] names = new String[this.dimensions.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = this.dimensions[i].name;
        }
        return names;
    }

    @Override
    public int[] getGridEnvelope() {
        int[] shape = new int[this.dimensions.length];
        for (int i = 0; i < shape.length; ++i) {
            shape[i] = this.dimensions[i].length;
        }
        return shape;
    }

    @Override
    public Object[] getAttributeValues(String attributeName, boolean numeric) {
        Attribute attribute = this.attributes.get(attributeName);
        if (attribute != null) {
            return numeric ? attribute.numberValues() : attribute.stringValues();
        }
        return new Object[0];
    }

    @Override
    public Object read() throws IOException, DataStoreException {
        if (this.reader == null) {
            throw new DataStoreException(this.unknownType());
        }
        long length = 1L;
        for (Dimension dimension : this.dimensions) {
            length *= (long)dimension.length;
        }
        if (length > Integer.MAX_VALUE) {
            throw new DataStoreException(Errors.format((short)25, (Object)this.name, (Object)length));
        }
        int dimension = this.dimensions.length;
        long[] size = new long[dimension];
        int[] sub = new int[dimension];
        for (int i = 0; i < dimension; ++i) {
            sub[i] = 1;
            size[i] = this.dimensions[dimension - 1 - i].length();
        }
        return this.reader.read(new Region(size, new long[dimension], size, sub));
    }

    @Override
    public Object read(int[] areaLower, int[] areaUpper, int[] subsampling) throws IOException, DataStoreException {
        if (this.reader == null) {
            throw new DataStoreException(this.unknownType());
        }
        int dimension = this.dimensions.length;
        long[] size = new long[dimension];
        long[] lower = new long[dimension];
        long[] upper = new long[dimension];
        int[] sub = new int[dimension];
        for (int i = 0; i < dimension; ++i) {
            int j = dimension - 1 - i;
            lower[i] = (long)areaLower[j] & 0xFFFFFFFFL;
            upper[i] = (long)areaUpper[j] & 0xFFFFFFFFL;
            sub[i] = subsampling[j];
            size[i] = this.dimensions[j].length();
        }
        return this.reader.read(new Region(size, lower, upper, sub));
    }

    private String unknownType() {
        return Errors.format((short)118, (Object)("NetCDF:" + this.dataType));
    }
}

