/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf;

import java.io.Closeable;
import java.io.IOException;
import java.util.Date;
import javax.measure.unit.Unit;
import org.apache.sis.internal.jdk7.Objects;
import org.apache.sis.internal.netcdf.GridGeometry;
import org.apache.sis.internal.netcdf.Variable;
import org.apache.sis.measure.Units;
import org.apache.sis.util.logging.WarningListeners;

public abstract class Decoder
implements Closeable {
    public final WarningListeners<?> listeners;
    public volatile boolean canceled;

    protected Decoder(WarningListeners<?> listeners) {
        Objects.requireNonNull(listeners);
        this.listeners = listeners;
    }

    public abstract void setSearchPath(String ... var1) throws IOException;

    public abstract String[] getSearchPath() throws IOException;

    public abstract String stringValue(String var1) throws IOException;

    public abstract Number numericValue(String var1) throws IOException;

    protected final Number parseNumber(String value) {
        int s = value.indexOf(32);
        if (s >= 0) {
            value = value.substring(0, s);
        }
        try {
            return Double.valueOf(value);
        }
        catch (NumberFormatException e) {
            this.listeners.warning(null, (Exception)e);
            return null;
        }
    }

    public abstract Date dateValue(String var1) throws IOException;

    public final Unit<?> unitValue(String name) throws IOException {
        String unit = this.stringValue(name);
        if (unit != null) {
            try {
                return Units.valueOf((String)unit);
            }
            catch (IllegalArgumentException e) {
                this.listeners.warning(null, (Exception)e);
            }
        }
        return null;
    }

    public abstract Date[] numberToDate(String var1, Number ... var2) throws IOException;

    public String getId() throws IOException {
        return this.stringValue("_Id");
    }

    public String getTitle() throws IOException {
        return this.stringValue("_Title");
    }

    public abstract Variable[] getVariables() throws IOException;

    public abstract GridGeometry[] getGridGeometries() throws IOException;
}

