/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf;

import org.apache.sis.internal.netcdf.GridGeometry;
import org.apache.sis.storage.netcdf.AttributeNames;
import org.apache.sis.util.ArraysExt;

public final class Axis {
    public final AttributeNames.Dimension attributeNames;
    public final int[] sourceDimensions;
    public final int[] sourceSizes;

    public Axis(GridGeometry owner, AttributeNames.Dimension attributeNames, int[] sourceDimensions, int[] sourceSizes) {
        this.attributeNames = attributeNames;
        this.sourceDimensions = sourceDimensions;
        this.sourceSizes = sourceSizes;
        if (sourceDimensions.length == 2) {
            int up0 = sourceSizes[0];
            int up1 = sourceSizes[1];
            int mid0 = up0 / 2;
            int mid1 = up1 / 2;
            double d1 = (owner.coordinateForCurrentAxis(0, mid1) - owner.coordinateForCurrentAxis(up0 - 1, mid1)) / (double)up0;
            double d2 = (owner.coordinateForCurrentAxis(mid0, 0) - owner.coordinateForCurrentAxis(mid0, up1 - 1)) / (double)up1;
            if (Math.abs(d2) > Math.abs(d1)) {
                sourceSizes[0] = up1;
                sourceSizes[1] = up0;
                ArraysExt.swap((int[])sourceDimensions, (int)0, (int)1);
            }
        }
    }
}

