/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.netcdf;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.nio.ByteBuffer;
import org.apache.sis.internal.netcdf.Decoder;
import org.apache.sis.internal.netcdf.impl.ChannelDecoder;
import org.apache.sis.internal.storage.ChannelDataInput;
import org.apache.sis.internal.system.SystemListener;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreProvider;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.storage.netcdf.NetcdfStore;
import org.apache.sis.util.logging.WarningListeners;

public class NetcdfStoreProvider
extends DataStoreProvider {
    private static final String UCAR_CLASSNAME = "ucar.nc2.NetcdfFile";
    private static Class<?> netcdfFileClass;
    private static volatile Method canOpenFromPath;
    private static volatile Constructor<? extends Decoder> createFromPath;
    private static volatile Constructor<? extends Decoder> createFromUCAR;

    public Boolean canOpen(StorageConnector storage) throws DataStoreException {
        String path;
        ByteBuffer buffer = (ByteBuffer)storage.getStorageAs(ByteBuffer.class);
        if (buffer != null) {
            if (buffer.remaining() < 4) {
                return null;
            }
            int header = buffer.getInt(buffer.position());
            if ((header & 0xFFFFFF00) == 1128547840) {
                return Boolean.TRUE;
            }
        }
        if ((path = (String)storage.getStorageAs(String.class)) != null) {
            NetcdfStoreProvider.ensureInitialized();
            Method method = canOpenFromPath;
            if (method != null) {
                try {
                    return (Boolean)method.invoke(null, path);
                }
                catch (IllegalAccessException e) {
                    throw new AssertionError((Object)e);
                }
                catch (InvocationTargetException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof DataStoreException) {
                        throw (DataStoreException)cause;
                    }
                    if (cause instanceof RuntimeException) {
                        throw (RuntimeException)cause;
                    }
                    if (cause instanceof Error) {
                        throw (Error)cause;
                    }
                    throw new DataStoreException((Throwable)e);
                }
            }
        }
        for (Class<?> type = storage.getStorage().getClass(); type != null; type = type.getSuperclass()) {
            if (!UCAR_CLASSNAME.equals(type.getName())) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public DataStore open(StorageConnector storage) throws DataStoreException {
        return new NetcdfStore(storage);
    }

    static Decoder decoder(WarningListeners<?> listeners, StorageConnector storage) throws IOException, DataStoreException {
        Object keepOpen;
        Decoder decoder2;
        ChannelDataInput input = (ChannelDataInput)storage.getStorageAs(ChannelDataInput.class);
        if (input != null) {
            try {
                decoder2 = new ChannelDecoder(listeners, input);
                keepOpen = input;
            }
            catch (DataStoreException e) {
                String path = (String)storage.getStorageAs(String.class);
                if (path != null) {
                    Decoder decoder2 = NetcdfStoreProvider.createByReflection(listeners, path, false);
                    String keepOpen2 = path;
                }
                throw e;
            }
        } else {
            keepOpen = storage.getStorage();
            decoder2 = NetcdfStoreProvider.createByReflection(listeners, keepOpen, true);
        }
        storage.closeAllExcept(keepOpen);
        return decoder2;
    }

    private static Decoder createByReflection(WarningListeners<?> listeners, Object input, boolean isUCAR) throws IOException, DataStoreException {
        Class<Object> expectedType;
        Constructor<? extends Decoder> constructor;
        NetcdfStoreProvider.ensureInitialized();
        if (isUCAR) {
            constructor = createFromUCAR;
            expectedType = netcdfFileClass;
        } else {
            constructor = createFromPath;
            expectedType = String.class;
        }
        if (constructor == null || !expectedType.isInstance(input)) {
            return null;
        }
        try {
            return constructor.newInstance(listeners, input);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof DataStoreException) {
                throw (DataStoreException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new UndeclaredThrowableException(cause);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void ensureInitialized() {
        if (netcdfFileClass != null) return;
        Class<NetcdfStoreProvider> clazz = NetcdfStoreProvider.class;
        synchronized (NetcdfStoreProvider.class) {
            try {
                netcdfFileClass = Class.forName(UCAR_CLASSNAME);
            }
            catch (ClassNotFoundException e) {
                netcdfFileClass = Void.TYPE;
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            try {
                canOpenFromPath = netcdfFileClass.getMethod("canOpen", String.class);
                assert (canOpenFromPath.getReturnType() == Boolean.TYPE);
                Class<Decoder> wrapper = Class.forName("org.apache.sis.internal.netcdf.ucar.DecoderWrapper").asSubclass(Decoder.class);
                Class[] parameterTypes = new Class[]{WarningListeners.class, netcdfFileClass};
                createFromUCAR = wrapper.getConstructor(parameterTypes);
                parameterTypes[1] = String.class;
                createFromPath = wrapper.getConstructor(parameterTypes);
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
            return;
        }
    }

    static synchronized void reset() {
        netcdfFileClass = null;
        canOpenFromPath = null;
        createFromUCAR = null;
        createFromPath = null;
    }

    static {
        SystemListener.add((SystemListener)new SystemListener("org.apache.sis.storage.netcdf"){

            protected void classpathChanged() {
                NetcdfStoreProvider.reset();
            }
        });
    }
}

