/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.netcdf;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.measure.converter.ConversionException;
import javax.measure.converter.UnitConverter;
import javax.measure.unit.NonSI;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.apache.sis.internal.netcdf.Axis;
import org.apache.sis.internal.netcdf.Decoder;
import org.apache.sis.internal.netcdf.GridGeometry;
import org.apache.sis.internal.netcdf.Variable;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.metadata.iso.DefaultIdentifier;
import org.apache.sis.metadata.iso.DefaultMetadata;
import org.apache.sis.metadata.iso.citation.DefaultAddress;
import org.apache.sis.metadata.iso.citation.DefaultCitation;
import org.apache.sis.metadata.iso.citation.DefaultCitationDate;
import org.apache.sis.metadata.iso.citation.DefaultContact;
import org.apache.sis.metadata.iso.citation.DefaultOnlineResource;
import org.apache.sis.metadata.iso.citation.DefaultResponsibleParty;
import org.apache.sis.metadata.iso.constraint.DefaultLegalConstraints;
import org.apache.sis.metadata.iso.content.DefaultBand;
import org.apache.sis.metadata.iso.content.DefaultCoverageDescription;
import org.apache.sis.metadata.iso.content.DefaultImageDescription;
import org.apache.sis.metadata.iso.content.DefaultRangeElementDescription;
import org.apache.sis.metadata.iso.distribution.DefaultDistribution;
import org.apache.sis.metadata.iso.distribution.DefaultDistributor;
import org.apache.sis.metadata.iso.extent.DefaultExtent;
import org.apache.sis.metadata.iso.extent.DefaultGeographicBoundingBox;
import org.apache.sis.metadata.iso.extent.DefaultGeographicDescription;
import org.apache.sis.metadata.iso.extent.DefaultTemporalExtent;
import org.apache.sis.metadata.iso.extent.DefaultVerticalExtent;
import org.apache.sis.metadata.iso.identification.DefaultDataIdentification;
import org.apache.sis.metadata.iso.identification.DefaultKeywords;
import org.apache.sis.metadata.iso.lineage.DefaultLineage;
import org.apache.sis.metadata.iso.quality.DefaultDataQuality;
import org.apache.sis.metadata.iso.spatial.DefaultDimension;
import org.apache.sis.metadata.iso.spatial.DefaultGridSpatialRepresentation;
import org.apache.sis.storage.netcdf.AttributeNames;
import org.apache.sis.util.iso.DefaultNameFactory;
import org.apache.sis.util.iso.SimpleInternationalString;
import org.apache.sis.util.iso.Types;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.Metadata;
import org.opengis.metadata.citation.Address;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.Contact;
import org.opengis.metadata.citation.DateType;
import org.opengis.metadata.citation.OnLineFunction;
import org.opengis.metadata.citation.OnlineResource;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.metadata.citation.Role;
import org.opengis.metadata.constraint.Restriction;
import org.opengis.metadata.content.Band;
import org.opengis.metadata.content.RangeElementDescription;
import org.opengis.metadata.distribution.Distribution;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.identification.DataIdentification;
import org.opengis.metadata.identification.KeywordType;
import org.opengis.metadata.identification.Keywords;
import org.opengis.metadata.identification.TopicCategory;
import org.opengis.metadata.lineage.Lineage;
import org.opengis.metadata.maintenance.ScopeCode;
import org.opengis.metadata.spatial.CellGeometry;
import org.opengis.metadata.spatial.GridSpatialRepresentation;
import org.opengis.metadata.spatial.SpatialRepresentationType;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.util.InternationalString;

final class MetadataReader {
    private static final String[] SEARCH_PATH = new String[]{"NCISOMetadata", "CFMetadata", null, "THREDDSMetadata"};
    private static final String KEYWORD_SEPARATOR = ",";
    private static final VerticalCRS VERTICAL_CRS = null;
    private final Decoder decoder;
    private final String[] searchPath;
    private transient DefaultNameFactory nameFactory;
    private transient ResponsibleParty pointOfContact;

    MetadataReader(Decoder decoder) throws IOException {
        this.decoder = decoder;
        decoder.setSearchPath(SEARCH_PATH);
        this.searchPath = decoder.getSearchPath();
    }

    private static InternationalString toInternationalString(String value) {
        return value != null ? new SimpleInternationalString(value) : null;
    }

    private static <T> void addIfAbsent(Collection<T> collection, T element) {
        if (!collection.contains(element)) {
            collection.add(element);
        }
    }

    private static <T> Set<T> addIfNonNull(Set<T> collection, T element) {
        if (element != null) {
            if (collection == null) {
                collection = new LinkedHashSet<T>(4);
            }
            collection.add(element);
        }
        return collection;
    }

    private static boolean isDefined(CharSequence metadata, String attribute) {
        return attribute == null || metadata != null && ((Object)metadata).toString().equals(attribute);
    }

    private static boolean isDefined(Collection<String> metadata, String attribute) {
        return attribute == null || metadata.contains(attribute);
    }

    private static boolean isDefined(OnlineResource resource, String url) {
        return url == null || resource != null && MetadataReader.isDefined(resource.getLinkage().toString(), url);
    }

    private static boolean isDefined(Address address, String email) {
        return email == null || address != null && MetadataReader.isDefined(address.getElectronicMailAddresses(), email);
    }

    private OnlineResource createOnlineResource(String url) {
        if (url != null) {
            try {
                DefaultOnlineResource resource = new DefaultOnlineResource(new URI(url));
                resource.setProtocol("http");
                resource.setApplicationProfile("web browser");
                resource.setFunction(OnLineFunction.INFORMATION);
                return resource;
            }
            catch (URISyntaxException e) {
                this.decoder.listeners.warning(null, (Exception)e);
            }
        }
        return null;
    }

    private static Address createAddress(String email) {
        if (email != null) {
            DefaultAddress address = new DefaultAddress();
            address.getElectronicMailAddresses().add(email);
            return address;
        }
        return null;
    }

    private static Contact createContact(Address address, OnlineResource url) {
        if (address != null || url != null) {
            DefaultContact contact = new DefaultContact();
            contact.setAddress(address);
            contact.setOnlineResource(url);
            return contact;
        }
        return null;
    }

    private Identifier getFileIdentifier() throws IOException {
        String identifier = this.decoder.stringValue("id");
        if (identifier == null && (identifier = this.decoder.getId()) == null) {
            return null;
        }
        String namespace = this.decoder.stringValue("naming_authority");
        return new DefaultIdentifier((Citation)(namespace != null ? new DefaultCitation((CharSequence)namespace) : null), identifier);
    }

    private ResponsibleParty createResponsibleParty(AttributeNames.Responsible keys, boolean isPointOfContact) throws IOException {
        String individualName = this.decoder.stringValue(keys.NAME);
        String organisationName = this.decoder.stringValue(keys.INSTITUTION);
        String email = this.decoder.stringValue(keys.EMAIL);
        String url = this.decoder.stringValue(keys.URL);
        if (individualName == null && organisationName == null && email == null && url == null) {
            return null;
        }
        Role role = (Role)Types.forCodeName(Role.class, (String)this.decoder.stringValue(keys.ROLE), (boolean)true);
        if (role == null) {
            role = isPointOfContact ? Role.POINT_OF_CONTACT : keys.DEFAULT_ROLE;
        }
        ResponsibleParty party = this.pointOfContact;
        Contact contact = null;
        Address address = null;
        OnlineResource resource = null;
        if (party != null) {
            contact = party.getContactInfo();
            if (contact != null) {
                address = contact.getAddress();
                resource = contact.getOnlineResource();
            }
            if (!MetadataReader.isDefined(resource, url)) {
                resource = null;
                contact = null;
                party = null;
            }
            if (!MetadataReader.isDefined(address, email)) {
                address = null;
                contact = null;
                party = null;
            }
            if (!(party == null || MetadataReader.isDefined((CharSequence)party.getOrganisationName(), organisationName) && MetadataReader.isDefined(party.getIndividualName(), individualName))) {
                party = null;
            }
        }
        if (party == null) {
            if (contact == null) {
                if (address == null) {
                    address = MetadataReader.createAddress(email);
                }
                if (resource == null) {
                    resource = this.createOnlineResource(url);
                }
                contact = MetadataReader.createContact(address, resource);
            }
            if (individualName != null || organisationName != null || contact != null) {
                DefaultResponsibleParty np = new DefaultResponsibleParty(role);
                np.setIndividualName(individualName);
                np.setOrganisationName(MetadataReader.toInternationalString(organisationName));
                np.setContactInfo(contact);
                party = np;
            }
        }
        return party;
    }

    private Citation createCitation(Identifier identifier) throws IOException {
        String title = this.decoder.stringValue("title");
        if (title == null && (title = this.decoder.stringValue("full_name")) == null && (title = this.decoder.stringValue("name")) == null) {
            title = this.decoder.getTitle();
        }
        Date creation = this.decoder.dateValue("date_created");
        Date modified = this.decoder.dateValue("date_modified");
        Date issued = this.decoder.dateValue("date_issued");
        String references = this.decoder.stringValue("references");
        DefaultCitation citation = new DefaultCitation((CharSequence)title);
        if (identifier != null) {
            citation.getIdentifiers().add(identifier);
        }
        if (creation != null) {
            citation.getDates().add(new DefaultCitationDate(creation, DateType.CREATION));
        }
        if (modified != null) {
            citation.getDates().add(new DefaultCitationDate(modified, DateType.REVISION));
        }
        if (issued != null) {
            citation.getDates().add(new DefaultCitationDate(issued, DateType.PUBLICATION));
        }
        if (this.pointOfContact != null) {
            DefaultResponsibleParty np = new DefaultResponsibleParty(Role.ORIGINATOR);
            np.setIndividualName(this.pointOfContact.getIndividualName());
            np.setOrganisationName(this.pointOfContact.getOrganisationName());
            np.setContactInfo(this.pointOfContact.getContactInfo());
            citation.getCitedResponsibleParties().add(np);
        }
        for (String path : this.searchPath) {
            this.decoder.setSearchPath(path);
            ResponsibleParty contributor = this.createResponsibleParty(AttributeNames.CONTRIBUTOR, false);
            if (contributor == null || contributor == this.pointOfContact) continue;
            MetadataReader.addIfAbsent(citation.getCitedResponsibleParties(), contributor);
        }
        this.decoder.setSearchPath(this.searchPath);
        citation.setOtherCitationDetails(MetadataReader.toInternationalString(references));
        return citation.isEmpty() ? null : citation;
    }

    private DataIdentification createIdentificationInfo(Identifier identifier, Set<InternationalString> publisher) throws IOException {
        DefaultDataIdentification identification = null;
        Set<InternationalString> project = null;
        DefaultLegalConstraints constraints = null;
        boolean hasExtent = false;
        for (String path : this.searchPath) {
            Extent extent;
            this.decoder.setSearchPath(path);
            Keywords standard = this.createKeywords(KeywordType.THEME, true);
            Keywords keywords = this.createKeywords(KeywordType.THEME, false);
            String topic = this.decoder.stringValue("topic_category");
            String type = this.decoder.stringValue("cdm_data_type");
            String credits = this.decoder.stringValue("acknowledgment");
            String license = this.decoder.stringValue("license");
            String access = this.decoder.stringValue("acces_constraint");
            Extent extent2 = extent = hasExtent ? null : this.createExtent();
            if (standard != null || keywords != null || topic != null || type != null || credits != null || license != null || access != null || extent != null) {
                if (identification == null) {
                    identification = new DefaultDataIdentification();
                }
                if (topic != null) {
                    MetadataReader.addIfAbsent(identification.getTopicCategories(), Types.forCodeName(TopicCategory.class, (String)topic, (boolean)true));
                }
                if (type != null) {
                    MetadataReader.addIfAbsent(identification.getSpatialRepresentationTypes(), Types.forCodeName(SpatialRepresentationType.class, (String)type, (boolean)true));
                }
                if (standard != null) {
                    MetadataReader.addIfAbsent(identification.getDescriptiveKeywords(), standard);
                }
                if (keywords != null) {
                    MetadataReader.addIfAbsent(identification.getDescriptiveKeywords(), keywords);
                }
                if (credits != null) {
                    MetadataReader.addIfAbsent(identification.getCredits(), credits);
                }
                if (license != null) {
                    constraints = new DefaultLegalConstraints((CharSequence)license);
                    MetadataReader.addIfAbsent(identification.getResourceConstraints(), constraints);
                }
                if (access != null) {
                    for (String keyword : access.split(KEYWORD_SEPARATOR)) {
                        if ((keyword = keyword.trim()).isEmpty()) continue;
                        if (constraints == null) {
                            constraints = new DefaultLegalConstraints();
                            identification.getResourceConstraints().add(constraints);
                        }
                        MetadataReader.addIfAbsent(constraints.getAccessConstraints(), Types.forCodeName(Restriction.class, (String)keyword, (boolean)true));
                    }
                }
                if (extent != null) {
                    identification.getExtents().add(extent);
                    hasExtent = true;
                }
            }
            project = MetadataReader.addIfNonNull(project, MetadataReader.toInternationalString(this.decoder.stringValue("project")));
        }
        this.decoder.setSearchPath(this.searchPath);
        Citation citation = this.createCitation(identifier);
        String summary = this.decoder.stringValue("summary");
        String purpose = this.decoder.stringValue("purpose");
        if (identification == null) {
            if (citation == null && summary == null && purpose == null && project == null && publisher == null && this.pointOfContact == null) {
                return null;
            }
            identification = new DefaultDataIdentification();
        }
        identification.setCitation(citation);
        identification.setAbstract(MetadataReader.toInternationalString(summary));
        identification.setPurpose(MetadataReader.toInternationalString(purpose));
        if (this.pointOfContact != null) {
            identification.getPointOfContacts().add(this.pointOfContact);
        }
        MetadataReader.addKeywords(identification, project, "project");
        MetadataReader.addKeywords(identification, publisher, "dataCenter");
        identification.setSupplementalInformation(MetadataReader.toInternationalString(this.decoder.stringValue("comment")));
        return identification;
    }

    private static void addKeywords(DefaultDataIdentification addTo, Set<InternationalString> words, String type) {
        if (words != null) {
            DefaultKeywords keywords = new DefaultKeywords();
            keywords.setKeywords(words);
            keywords.setType((KeywordType)Types.forCodeName(KeywordType.class, (String)type, (boolean)true));
            addTo.getDescriptiveKeywords().add(keywords);
        }
    }

    private Keywords createKeywords(KeywordType type, boolean standard) throws IOException {
        String list = this.decoder.stringValue(standard ? "standard_name" : "keywords");
        DefaultKeywords keywords = null;
        if (list != null) {
            LinkedHashSet<SimpleInternationalString> words = new LinkedHashSet<SimpleInternationalString>();
            for (String keyword : list.split(KEYWORD_SEPARATOR)) {
                if ((keyword = keyword.trim()).isEmpty()) continue;
                words.add(new SimpleInternationalString(keyword));
            }
            if (!words.isEmpty()) {
                keywords = new DefaultKeywords();
                keywords.setKeywords(words);
                keywords.setType(type);
                String vocabulary = this.decoder.stringValue(standard ? "standard_name_vocabulary" : "keywords_vocabulary");
                if (vocabulary != null) {
                    keywords.setThesaurusName((Citation)new DefaultCitation((CharSequence)vocabulary));
                }
            }
        }
        return keywords;
    }

    private GridSpatialRepresentation createSpatialRepresentationInfo(GridGeometry cs) throws IOException {
        DefaultGridSpatialRepresentation grid = new DefaultGridSpatialRepresentation();
        grid.setNumberOfDimensions(Integer.valueOf(cs.getTargetDimensions()));
        Axis[] axes = cs.getAxes();
        int i = axes.length;
        while (--i >= 0) {
            Axis axis = axes[i];
            if (axis.sourceDimensions.length == 0) continue;
            DefaultDimension dimension = new DefaultDimension();
            dimension.setDimensionSize(Integer.valueOf(axis.sourceSizes[0]));
            AttributeNames.Dimension attributeNames = axis.attributeNames;
            if (attributeNames != null) {
                dimension.setDimensionName(attributeNames.DEFAULT_NAME_TYPE);
                Number value = this.decoder.numericValue(attributeNames.RESOLUTION);
                if (value != null) {
                    dimension.setResolution(Double.valueOf(value instanceof Double ? ((Double)value).doubleValue() : value.doubleValue()));
                }
            }
            grid.getAxisDimensionProperties().add(dimension);
        }
        grid.setCellGeometry(CellGeometry.AREA);
        return grid;
    }

    private Extent createExtent() throws IOException {
        String identifier;
        DefaultExtent extent = null;
        Number xmin = this.decoder.numericValue(AttributeNames.LONGITUDE.MINIMUM);
        Number xmax = this.decoder.numericValue(AttributeNames.LONGITUDE.MAXIMUM);
        Number ymin = this.decoder.numericValue(AttributeNames.LATITUDE.MINIMUM);
        Number ymax = this.decoder.numericValue(AttributeNames.LATITUDE.MAXIMUM);
        Number zmin = this.decoder.numericValue(AttributeNames.VERTICAL.MINIMUM);
        Number zmax = this.decoder.numericValue(AttributeNames.VERTICAL.MAXIMUM);
        if (xmin != null || xmax != null || ymin != null || ymax != null) {
            UnitConverter xConv = this.getConverterTo(this.decoder.unitValue(AttributeNames.LONGITUDE.UNITS), NonSI.DEGREE_ANGLE);
            UnitConverter yConv = this.getConverterTo(this.decoder.unitValue(AttributeNames.LATITUDE.UNITS), NonSI.DEGREE_ANGLE);
            extent = new DefaultExtent();
            extent.getGeographicElements().add(new DefaultGeographicBoundingBox(MetadataReader.valueOf(xmin, xConv), MetadataReader.valueOf(xmax, xConv), MetadataReader.valueOf(ymin, yConv), MetadataReader.valueOf(ymax, yConv)));
        }
        if (zmin != null || zmax != null) {
            UnitConverter c = this.getConverterTo(this.decoder.unitValue(AttributeNames.VERTICAL.UNITS), (Unit<?>)SI.METRE);
            double min = MetadataReader.valueOf(zmin, c);
            double max = MetadataReader.valueOf(zmax, c);
            if ("down".equals(this.decoder.stringValue(AttributeNames.VERTICAL.POSITIVE))) {
                double tmp = min;
                min = -max;
                max = -tmp;
            }
            if (extent == null) {
                extent = new DefaultExtent();
            }
            extent.getVerticalElements().add(new DefaultVerticalExtent(min, max, VERTICAL_CRS));
        }
        Date startTime = this.decoder.dateValue(AttributeNames.TIME.MINIMUM);
        Date endTime = this.decoder.dateValue(AttributeNames.TIME.MAXIMUM);
        if (startTime == null && endTime == null) {
            String symbol;
            Number tmin = this.decoder.numericValue(AttributeNames.TIME.MINIMUM);
            Number tmax = this.decoder.numericValue(AttributeNames.TIME.MAXIMUM);
            if ((tmin != null || tmax != null) && (symbol = this.decoder.stringValue(AttributeNames.TIME.UNITS)) != null) {
                Date[] dates = this.decoder.numberToDate(symbol, tmin, tmax);
                startTime = dates[0];
                endTime = dates[1];
            }
        }
        if (startTime != null || endTime != null) {
            try {
                DefaultTemporalExtent t = new DefaultTemporalExtent();
                t.setBounds(startTime, endTime);
                if (extent == null) {
                    extent = new DefaultExtent();
                }
                extent.getTemporalElements().add(t);
            }
            catch (UnsupportedOperationException e) {
                this.decoder.listeners.warning(null, (Exception)e);
            }
        }
        if ((identifier = this.decoder.stringValue("geographic_identifier")) != null) {
            if (extent == null) {
                extent = new DefaultExtent();
            }
            extent.getGeographicElements().add(new DefaultGeographicDescription(null, identifier));
        }
        return extent;
    }

    private UnitConverter getConverterTo(Unit<?> source, Unit<?> target) {
        if (source != null) {
            try {
                return source.getConverterToAny(target);
            }
            catch (ConversionException e) {
                this.decoder.listeners.warning(null, (Exception)((Object)e));
            }
        }
        return null;
    }

    private static double valueOf(Number value, UnitConverter converter) {
        double n = Double.NaN;
        if (value != null) {
            n = value.doubleValue();
            if (converter != null) {
                n = converter.convert(n);
            }
        }
        return n;
    }

    private Collection<DefaultCoverageDescription> createContentInfo() throws IOException {
        HashMap<List<String>, DefaultCoverageDescription> contents = new HashMap<List<String>, DefaultCoverageDescription>(4);
        String processingLevel = this.decoder.stringValue("processing_level");
        for (Variable variable : this.decoder.getVariables()) {
            if (!variable.isCoverage(2)) continue;
            List<String> dimensions = Arrays.asList(variable.getGridDimensionNames());
            DefaultCoverageDescription content = (DefaultCoverageDescription)contents.get(dimensions);
            if (content == null) {
                if (processingLevel != null) {
                    content = new DefaultImageDescription();
                    ((DefaultImageDescription)content).setProcessingLevelCode((Identifier)new DefaultIdentifier(processingLevel));
                } else {
                    content = new DefaultCoverageDescription();
                }
                contents.put(dimensions, content);
            }
            content.getDimensions().add(this.createSampleDimension(variable));
            Object[] names = variable.getAttributeValues("flag_names", false);
            Object[] meanings = variable.getAttributeValues("flag_meanings", false);
            Object[] masks = variable.getAttributeValues("flag_masks", true);
            Object[] values = variable.getAttributeValues("flag_values", true);
            int length = Math.max(masks.length, Math.max(values.length, Math.max(names.length, meanings.length)));
            for (int i = 0; i < length; ++i) {
                RangeElementDescription element = this.createRangeElementDescription(variable, i < names.length ? (String)names[i] : null, i < meanings.length ? (String)meanings[i] : null, i < masks.length ? (Number)((Number)masks[i]) : (Number)null, i < values.length ? (Number)((Number)values[i]) : (Number)null);
                if (element == null) continue;
                content.getRangeElementDescriptions().add(element);
            }
        }
        return contents.values();
    }

    private Band createSampleDimension(Variable variable) throws IOException {
        String description;
        DefaultBand band = new DefaultBand();
        String name = variable.getName();
        if (name != null && !(name = name.trim()).isEmpty()) {
            if (this.nameFactory == null) {
                this.nameFactory = DefaultFactories.NAMES;
            }
            band.setSequenceIdentifier(this.nameFactory.createMemberName(null, (CharSequence)name, this.nameFactory.createTypeName(null, (CharSequence)variable.getDataTypeName())));
        }
        if ((description = variable.getDescription()) != null && !(description = description.trim()).isEmpty() && !description.equals(name)) {
            band.setDescriptor(MetadataReader.toInternationalString(description));
        }
        return band;
    }

    private RangeElementDescription createRangeElementDescription(Variable variable, String name, String meaning, Number mask, Number value) throws IOException {
        if (name != null && meaning != null) {
            DefaultRangeElementDescription element = new DefaultRangeElementDescription();
            element.setName(MetadataReader.toInternationalString(name));
            element.setDefinition(MetadataReader.toInternationalString(meaning));
            return element;
        }
        return null;
    }

    public Metadata read() throws IOException {
        DefaultMetadata metadata = new DefaultMetadata();
        metadata.setMetadataStandardName("ISO 19115-2 Geographic Information - Metadata Part 2 Extensions for imagery and gridded data");
        metadata.setMetadataStandardVersion("ISO 19115-2:2009(E)");
        Identifier identifier = this.getFileIdentifier();
        if (identifier != null) {
            InternationalString title;
            String code = identifier.getCode();
            Citation authority = identifier.getAuthority();
            if (authority != null && (title = authority.getTitle()) != null) {
                code = title.toString() + ':' + code;
            }
            metadata.setFileIdentifier(code);
        }
        metadata.setDateStamp(this.decoder.dateValue("metadata_creation"));
        metadata.getHierarchyLevels().add(ScopeCode.DATASET);
        String wms = this.decoder.stringValue("wms_service");
        String wcs = this.decoder.stringValue("wcs_service");
        if (wms != null || wcs != null) {
            metadata.getHierarchyLevels().add(ScopeCode.SERVICE);
        }
        for (String path : this.searchPath) {
            this.decoder.setSearchPath(path);
            ResponsibleParty party = this.createResponsibleParty(AttributeNames.CREATOR, true);
            if (party == null || party == this.pointOfContact) continue;
            MetadataReader.addIfAbsent(metadata.getContacts(), party);
            if (this.pointOfContact != null) continue;
            this.pointOfContact = party;
        }
        Set<InternationalString> publisher = null;
        DefaultDistribution distribution = null;
        for (String path : this.searchPath) {
            String history;
            this.decoder.setSearchPath(path);
            ResponsibleParty party = this.createResponsibleParty(AttributeNames.PUBLISHER, false);
            if (party != null) {
                if (distribution == null) {
                    distribution = new DefaultDistribution();
                    metadata.setDistributionInfo((Distribution)distribution);
                }
                DefaultDistributor distributor = new DefaultDistributor(party);
                MetadataReader.addIfAbsent(distribution.getDistributors(), distributor);
                publisher = MetadataReader.addIfNonNull(publisher, MetadataReader.toInternationalString(party.getIndividualName()));
            }
            if ((history = this.decoder.stringValue("history")) == null) continue;
            DefaultDataQuality quality = new DefaultDataQuality();
            DefaultLineage lineage = new DefaultLineage();
            lineage.setStatement((InternationalString)new SimpleInternationalString(history));
            quality.setLineage((Lineage)lineage);
            MetadataReader.addIfAbsent(metadata.getDataQualityInfo(), quality);
        }
        DataIdentification identification = this.createIdentificationInfo(identifier, publisher);
        if (identification != null) {
            metadata.getIdentificationInfo().add(identification);
        }
        metadata.setContentInfo(this.createContentInfo());
        for (GridGeometry cs : this.decoder.getGridGeometries()) {
            if (cs.getSourceDimensions() < 2 || cs.getTargetDimensions() < 2) continue;
            metadata.getSpatialRepresentationInfo().add(this.createSpatialRepresentationInfo(cs));
        }
        metadata.freeze();
        return metadata;
    }
}

