/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf.impl;

import java.io.IOException;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import javax.measure.converter.ConversionException;
import javax.measure.converter.UnitConverter;
import org.apache.sis.internal.jdk8.Function;
import org.apache.sis.internal.jdk8.JDK8;
import org.apache.sis.internal.netcdf.Decoder;
import org.apache.sis.internal.netcdf.GridGeometry;
import org.apache.sis.internal.netcdf.Variable;
import org.apache.sis.internal.netcdf.impl.Attribute;
import org.apache.sis.internal.netcdf.impl.Dimension;
import org.apache.sis.internal.netcdf.impl.GridGeometryInfo;
import org.apache.sis.internal.netcdf.impl.VariableInfo;
import org.apache.sis.internal.storage.ChannelDataInput;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.measure.Units;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.logging.WarningListeners;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.parameter.InvalidParameterCardinalityException;

public final class ChannelDecoder
extends Decoder {
    public static final int MAGIC_NUMBER = 1128547840;
    private static final String NAME_ENCODING = "UTF-8";
    private static final Locale NAME_LOCALE = Locale.US;
    private static final Pattern TIME_UNIT_PATTERN = Pattern.compile("(?i)\\bsince\\b");
    private static final boolean DEFAULT_TIMEZONE_IS_UTC = true;
    private static final int STREAMING = -1;
    private static final int DIMENSION = 10;
    private static final int VARIABLE = 11;
    private static final int ATTRIBUTE = 12;
    private final ChannelDataInput input;
    private final boolean is64bits;
    private final int numrecs;
    private final String encoding = "ISO-8859-1";
    private final VariableInfo[] variables;
    private final Map<String, Attribute> attributeMap;
    private transient GridGeometry[] gridGeometries;

    public ChannelDecoder(WarningListeners<?> listeners, ChannelDataInput input) throws IOException, DataStoreException {
        super(listeners);
        this.input = input;
        int version = input.readInt();
        if ((version & 0xFFFFFF00) != 1128547840) {
            throw new DataStoreException(this.errors().getString(92, (Object)"NetCDF", (Object)input.filename));
        }
        switch (version &= 0xFF) {
            case 1: {
                this.is64bits = false;
                break;
            }
            case 2: {
                this.is64bits = true;
                break;
            }
            default: {
                throw new DataStoreException(this.errors().getString(93, (Object)version));
            }
        }
        this.numrecs = input.readInt();
        Dimension[] dimensions = null;
        VariableInfo[] variables = null;
        Attribute[] attributes = null;
        block9: for (int i = 0; i < 3; ++i) {
            long tn = input.readLong();
            if (tn == 0L) continue;
            int tag = (int)(tn >>> 32);
            int nelems = (int)tn;
            this.ensureNonNegative(nelems, tag);
            switch (tag) {
                case 10: {
                    dimensions = this.readDimensions(nelems);
                    continue block9;
                }
                case 11: {
                    variables = this.readVariables(nelems, dimensions);
                    continue block9;
                }
                case 12: {
                    attributes = this.readAttributes(nelems);
                    continue block9;
                }
                default: {
                    throw this.malformedHeader();
                }
            }
        }
        this.attributeMap = this.toMap(attributes, Attribute.NAME_FUNCTION);
        this.variables = variables;
    }

    private static String tagName(int tag) {
        int key;
        switch (tag) {
            case 10: {
                key = 46;
                break;
            }
            case 11: {
                key = 47;
                break;
            }
            case 12: {
                key = 45;
                break;
            }
            default: {
                return Integer.toHexString(tag);
            }
        }
        return Vocabulary.format((int)key);
    }

    private Errors errors() {
        return Errors.getResources((Locale)this.listeners.getLocale());
    }

    private DataStoreException malformedHeader() {
        return new DataStoreException(this.errors().getString(79, (Object)"NetCDF", (Object)this.input.filename));
    }

    private void ensureNonNegative(int nelems, int tag) throws DataStoreException {
        if (nelems < 0) {
            throw new DataStoreException(this.errors().getString(78, (Object)(this.input.filename + ':' + ChannelDecoder.tagName(tag))));
        }
    }

    private int ensureBufferContains(int n, int dataSize, String name) throws IOException, DataStoreException {
        long size = ((long)n & 0xFFFFFFFFL) * (long)dataSize + 3L & 0xFFFFFFFFFFFFFFFCL;
        if (size > (long)this.input.buffer.capacity()) {
            name = this.input.filename + ':' + name;
            Errors errors = this.errors();
            throw new DataStoreException(n < 0 ? errors.getString(78, (Object)name) : errors.getString(94, (Object)name, (Object)n));
        }
        this.input.ensureBufferContains((int)size);
        return (int)size;
    }

    private long readOffset() throws IOException {
        return this.is64bits ? this.input.readLong() : this.input.readUnsignedInt();
    }

    private String readName() throws IOException, DataStoreException {
        int length = this.input.readInt();
        if (length < 0) {
            throw this.malformedHeader();
        }
        ByteBuffer buffer = this.input.buffer;
        int size = this.ensureBufferContains(length, 1, "<name>");
        String text = this.input.readString(length, NAME_ENCODING);
        buffer.position(buffer.position() + (size - length));
        return text;
    }

    private Object readValues(String name, int type, int length) throws IOException, DataStoreException {
        Object result;
        if (length == 0) {
            return null;
        }
        ByteBuffer buffer = this.input.buffer;
        int size = this.ensureBufferContains(length, VariableInfo.sizeOf(type), name);
        int position = buffer.position();
        switch (type) {
            case 2: {
                String text = this.input.readString(length, "ISO-8859-1").trim();
                result = text.isEmpty() ? null : text;
                break;
            }
            case 1: {
                byte[] array = new byte[length];
                buffer.get(array);
                result = array;
                break;
            }
            case 3: {
                short[] array = new short[length];
                buffer.asShortBuffer().get(array);
                result = array;
                break;
            }
            case 4: {
                int[] array = new int[length];
                buffer.asIntBuffer().get(array);
                result = array;
                break;
            }
            case 5: {
                float[] array = new float[length];
                buffer.asFloatBuffer().get(array);
                result = array;
                break;
            }
            case 6: {
                double[] array = new double[length];
                buffer.asDoubleBuffer().get(array);
                result = array;
                break;
            }
            default: {
                throw this.malformedHeader();
            }
        }
        buffer.position(position + size);
        return result;
    }

    private Dimension[] readDimensions(int nelems) throws IOException, DataStoreException {
        Dimension[] dimensions = new Dimension[nelems];
        for (int i = 0; i < nelems; ++i) {
            String name = this.readName();
            int length = this.input.readInt();
            if (length == 0 && (length = this.numrecs) == -1) {
                throw new DataStoreException(this.errors().getString(85, (Object)"numrecs"));
            }
            dimensions[i] = new Dimension(name, length);
        }
        return dimensions;
    }

    private Attribute[] readAttributes(int nelems) throws IOException, DataStoreException {
        Object[] attributes = new Attribute[nelems];
        int count = 0;
        for (int i = 0; i < nelems; ++i) {
            String name = this.readName();
            Object value = this.readValues(name, this.input.readInt(), this.input.readInt());
            if (value == null) continue;
            attributes[count++] = new Attribute(name, value);
        }
        return (Attribute[])ArraysExt.resize((Object[])attributes, (int)count);
    }

    private VariableInfo[] readVariables(int nelems, Dimension[] dimensions) throws IOException, DataStoreException {
        if (dimensions == null) {
            throw this.malformedHeader();
        }
        VariableInfo[] variables = new VariableInfo[nelems];
        for (int j = 0; j < nelems; ++j) {
            String name = this.readName();
            int n = this.input.readInt();
            Dimension[] varDims = new Dimension[n];
            try {
                for (int i = 0; i < n; ++i) {
                    varDims[i] = dimensions[this.input.readInt()];
                }
            }
            catch (IndexOutOfBoundsException cause) {
                DataStoreException e = this.malformedHeader();
                e.initCause((Throwable)cause);
                throw e;
            }
            Attribute[] attributes = null;
            long tn = this.input.readLong();
            if (tn != 0L) {
                int tag = (int)(tn >>> 32);
                int na = (int)tn;
                this.ensureNonNegative(na, tag);
                switch (tag) {
                    case 12: {
                        attributes = this.readAttributes(na);
                        break;
                    }
                    default: {
                        throw this.malformedHeader();
                    }
                }
            }
            variables[j] = new VariableInfo(this.input, name, varDims, dimensions, this.toMap(attributes, Attribute.NAME_FUNCTION), this.input.readInt(), this.input.readInt(), this.readOffset());
        }
        return variables;
    }

    private <E> Map<String, E> toMap(E[] elements, Function<E, String> nameFunction) throws DataStoreException {
        try {
            return CollectionsExt.toCaseInsensitiveNameMap(Arrays.asList(elements), nameFunction, (Locale)NAME_LOCALE);
        }
        catch (InvalidParameterCardinalityException e) {
            throw new DataStoreException(this.errors().getString(13, (Object)e.getParameterName()));
        }
    }

    @Override
    public void setSearchPath(String ... groupNames) throws IOException {
    }

    @Override
    public String[] getSearchPath() throws IOException {
        return new String[1];
    }

    private Attribute findAttribute(String name) {
        String lower;
        Attribute attribute = this.attributeMap.get(name);
        if (attribute == null && name != null && (lower = name.toLowerCase(NAME_LOCALE)) != name) {
            attribute = this.attributeMap.get(lower);
        }
        return attribute;
    }

    @Override
    public String stringValue(String name) throws IOException {
        Attribute attribute = this.findAttribute(name);
        if (attribute != null) {
            return attribute.value.toString();
        }
        return null;
    }

    @Override
    public Number numericValue(String name) throws IOException {
        Attribute attribute = this.findAttribute(name);
        if (attribute != null && attribute.value != null) {
            if (attribute.value instanceof String) {
                return this.parseNumber((String)attribute.value);
            }
            return (Number)Array.get(attribute.value, 0);
        }
        return null;
    }

    @Override
    public Date dateValue(String name) throws IOException {
        Attribute attribute = this.findAttribute(name);
        if (attribute != null && attribute.value instanceof String) {
            try {
                return JDK8.parseDateTime((String)((String)attribute.value), (boolean)true);
            }
            catch (IllegalArgumentException e) {
                this.listeners.warning(null, (Exception)e);
            }
        }
        return null;
    }

    @Override
    public Date[] numberToDate(String symbol, Number ... values) throws IOException {
        Date[] dates = new Date[values.length];
        String[] parts = TIME_UNIT_PATTERN.split(symbol);
        if (parts.length == 2) {
            try {
                UnitConverter converter = Units.valueOf((String)parts[0]).getConverterToAny(Units.MILLISECOND);
                long epoch = JDK8.parseDateTime((String)parts[1], (boolean)true).getTime();
                for (int i = 0; i < values.length; ++i) {
                    Number value = values[i];
                    if (value == null) continue;
                    dates[i] = new Date(epoch + Math.round(converter.convert(value.doubleValue())));
                }
            }
            catch (ConversionException e) {
                this.listeners.warning(null, (Exception)((Object)e));
            }
            catch (IllegalArgumentException e) {
                this.listeners.warning(null, (Exception)e);
            }
        }
        return dates;
    }

    @Override
    public Variable[] getVariables() throws IOException {
        return this.variables;
    }

    @Override
    public GridGeometry[] getGridGeometries() throws IOException {
        if (this.gridGeometries == null) {
            IdentityHashMap dimToAxes = new IdentityHashMap();
            for (VariableInfo variable : this.variables) {
                if (!variable.isCoordinateSystemAxis()) continue;
                for (Dimension dimension : variable.dimensions) {
                    CollectionsExt.addToMultiValuesMap(dimToAxes, (Object)dimension, (Object)variable);
                }
            }
            LinkedHashSet axes = new LinkedHashSet(4);
            LinkedHashMap<List<Dimension>, GridGeometryInfo> dimsToGG = new LinkedHashMap<List<Dimension>, GridGeometryInfo>();
            block2: for (VariableInfo variable : this.variables) {
                if (variable.isCoordinateSystemAxis()) continue;
                List<Dimension> dimensions = Arrays.asList(variable.dimensions);
                GridGeometryInfo gridGeometry = (GridGeometryInfo)dimsToGG.get(dimensions);
                if (gridGeometry == null) {
                    for (Dimension dimension : variable.dimensions) {
                        List axis = (List)dimToAxes.get(dimension);
                        if (axis == null) {
                            axes.clear();
                            continue block2;
                        }
                        axes.addAll(axis);
                    }
                    gridGeometry = new GridGeometryInfo(variable.dimensions, axes.toArray(new VariableInfo[axes.size()]));
                    dimsToGG.put(dimensions, gridGeometry);
                    axes.clear();
                }
                variable.gridGeometry = gridGeometry;
            }
            this.gridGeometries = dimsToGG.values().toArray(new GridGeometry[dimsToGG.size()]);
        }
        return this.gridGeometries;
    }

    @Override
    public void close() throws IOException {
        this.input.channel.close();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("SIS driver: \u201c").append(this.input.filename).append('\u201d');
        if (!this.input.channel.isOpen()) {
            buffer.append(" (closed)");
        }
        return buffer.toString();
    }
}

