/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf.impl;

import java.lang.reflect.Array;
import org.apache.sis.internal.jdk8.Function;
import org.apache.sis.util.Utilities;

final class Attribute {
    static final Function<Attribute, String> NAME_FUNCTION = new Function<Attribute, String>(){

        public String apply(Attribute value) {
            return value.name;
        }
    };
    final String name;
    final Object value;

    Attribute(String name, Object value) {
        this.name = name;
        this.value = value;
    }

    final String[] stringValues() {
        if (this.value instanceof String) {
            return new String[]{(String)this.value};
        }
        String[] values = new String[Array.getLength(this.value)];
        for (int i = 0; i < values.length; ++i) {
            values[i] = Array.get(this.value, i).toString();
        }
        return values;
    }

    final Number[] numberValues() {
        Number[] values = new Number[this.value instanceof String ? 0 : Array.getLength(this.value)];
        for (int i = 0; i < values.length; ++i) {
            values[i] = (Number)Array.get(this.value, i);
        }
        return values;
    }

    final boolean booleanValue() {
        return this.value instanceof String && Boolean.valueOf((String)this.value) != false;
    }

    public String toString() {
        return this.name + " = " + Utilities.deepToString((Object)this.value);
    }
}

