/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.web.filter;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.lang.util.StringUtils;
import org.apache.shiro.web.filter.AccessControlFilter;
import org.apache.shiro.web.util.WebUtils;

public class InvalidRequestFilter
extends AccessControlFilter {
    private static final List<String> SEMICOLON = Collections.unmodifiableList(Arrays.asList(";", "%3b", "%3B"));
    private static final List<String> BACKSLASH = Collections.unmodifiableList(Arrays.asList("\\", "%5c", "%5C"));
    private static final List<String> FORWARDSLASH = Collections.unmodifiableList(Arrays.asList("%2f", "%2F"));
    private static final List<String> PERIOD = Collections.unmodifiableList(Arrays.asList("%2e", "%2E"));
    private boolean blockSemicolon = true;
    private boolean blockBackslash = !WebUtils.isAllowBackslash();
    private boolean blockNonAscii = true;
    private PathTraversalBlockMode pathTraversalBlockMode = PathTraversalBlockMode.NORMAL;

    @Override
    protected boolean isAccessAllowed(ServletRequest req, ServletResponse response, Object mappedValue) throws Exception {
        HttpServletRequest request = WebUtils.toHttp(req);
        return this.isValid(request.getRequestURI()) && this.isValid(request.getServletPath()) && this.isValid(request.getPathInfo());
    }

    private boolean isValid(String uri) {
        return !StringUtils.hasText((String)uri) || !this.containsSemicolon(uri) && !this.containsBackslash(uri) && !this.containsNonAsciiCharacters(uri) && !this.containsTraversal(uri);
    }

    @Override
    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) throws Exception {
        WebUtils.toHttp(response).sendError(400, "Invalid request");
        return false;
    }

    private boolean containsSemicolon(String uri) {
        if (this.isBlockSemicolon()) {
            return SEMICOLON.stream().anyMatch(uri::contains);
        }
        return false;
    }

    private boolean containsBackslash(String uri) {
        if (this.isBlockBackslash()) {
            return BACKSLASH.stream().anyMatch(uri::contains);
        }
        return false;
    }

    private boolean containsNonAsciiCharacters(String uri) {
        if (this.isBlockNonAscii()) {
            return !InvalidRequestFilter.containsOnlyPrintableAsciiCharacters(uri);
        }
        return false;
    }

    private static boolean containsOnlyPrintableAsciiCharacters(String uri) {
        int length = uri.length();
        for (int i = 0; i < length; ++i) {
            char c = uri.charAt(i);
            if (c >= ' ' && c <= '~') continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean containsTraversal(String uri) {
        if (this.pathTraversalBlockMode == PathTraversalBlockMode.NORMAL) {
            if (this.isNormalized(uri)) return false;
            return true;
        }
        if (this.pathTraversalBlockMode != PathTraversalBlockMode.STRICT) return false;
        if (!this.isNormalized(uri)) return true;
        if (!PERIOD.stream().noneMatch(uri::contains)) return true;
        if (FORWARDSLASH.stream().noneMatch(uri::contains)) return false;
        return true;
    }

    private boolean isNormalized(String path) {
        if (path == null) {
            return true;
        }
        int i = path.length();
        while (i > 0) {
            int slashIndex = path.lastIndexOf(47, i - 1);
            int gap = i - slashIndex;
            if (gap == 2 && path.charAt(slashIndex + 1) == '.') {
                return false;
            }
            if (gap == 3 && path.charAt(slashIndex + 1) == '.' && path.charAt(slashIndex + 2) == '.') {
                return false;
            }
            i = slashIndex;
        }
        return true;
    }

    public boolean isBlockSemicolon() {
        return this.blockSemicolon;
    }

    public void setBlockSemicolon(boolean blockSemicolon) {
        this.blockSemicolon = blockSemicolon;
    }

    public boolean isBlockBackslash() {
        return this.blockBackslash;
    }

    public void setBlockBackslash(boolean blockBackslash) {
        this.blockBackslash = blockBackslash;
    }

    public boolean isBlockNonAscii() {
        return this.blockNonAscii;
    }

    public void setBlockNonAscii(boolean blockNonAscii) {
        this.blockNonAscii = blockNonAscii;
    }

    public PathTraversalBlockMode getPathTraversalBlockMode() {
        return this.pathTraversalBlockMode;
    }

    public void setBlockPathTraversal(PathTraversalBlockMode mode) {
        this.pathTraversalBlockMode = mode;
    }

    public boolean isBlockEncodedPeriod() {
        return this.pathTraversalBlockMode == PathTraversalBlockMode.STRICT;
    }

    public void setBlockEncodedPeriod(boolean blockEncodedPeriod) {
        this.setBlockPathTraversal(blockEncodedPeriod ? PathTraversalBlockMode.STRICT : PathTraversalBlockMode.NORMAL);
    }

    public boolean isBlockEncodedForwardSlash() {
        return this.pathTraversalBlockMode == PathTraversalBlockMode.STRICT;
    }

    public void setBlockEncodedForwardSlash(boolean blockEncodedForwardSlash) {
        this.setBlockPathTraversal(blockEncodedForwardSlash ? PathTraversalBlockMode.STRICT : PathTraversalBlockMode.NORMAL);
    }

    public boolean isBlockRewriteTraversal() {
        return this.pathTraversalBlockMode == PathTraversalBlockMode.NORMAL;
    }

    public void setBlockRewriteTraversal(boolean blockRewriteTraversal) {
        this.setBlockPathTraversal(blockRewriteTraversal ? PathTraversalBlockMode.NORMAL : PathTraversalBlockMode.NO_BLOCK);
    }

    @Deprecated
    public boolean isBlockTraversal() {
        return this.pathTraversalBlockMode != PathTraversalBlockMode.NO_BLOCK;
    }

    @Deprecated
    public void setBlockTraversal(boolean blockTraversal) {
        this.pathTraversalBlockMode = blockTraversal ? PathTraversalBlockMode.NORMAL : PathTraversalBlockMode.NO_BLOCK;
    }

    public static enum PathTraversalBlockMode {
        STRICT,
        NORMAL,
        NO_BLOCK;

    }
}

