/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.web.filter.authc;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.codec.Base64;
import org.apache.shiro.web.filter.authc.AuthenticatingFilter;
import org.apache.shiro.web.util.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicHttpAuthenticationFilter
extends AuthenticatingFilter {
    private static final Logger log = LoggerFactory.getLogger(BasicHttpAuthenticationFilter.class);
    protected static final String AUTHORIZATION_HEADER = "Authorization";
    protected static final String AUTHENTICATE_HEADER = "WWW-Authenticate";
    private String applicationName = "application";
    private String authcScheme = "BASIC";
    private String authzScheme = "BASIC";

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getAuthzScheme() {
        return this.authzScheme;
    }

    public void setAuthzScheme(String authzScheme) {
        this.authzScheme = authzScheme;
    }

    public String getAuthcScheme() {
        return this.authcScheme;
    }

    public void setAuthcScheme(String authcScheme) {
        this.authcScheme = authcScheme;
    }

    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) throws Exception {
        boolean loggedIn = false;
        if (this.isLoginAttempt(request, response)) {
            loggedIn = this.executeLogin(request, response);
        }
        if (!loggedIn) {
            this.sendChallenge(request, response);
        }
        return loggedIn;
    }

    protected boolean isLoginAttempt(ServletRequest request, ServletResponse response) {
        String authzHeader = this.getAuthzHeader(request);
        return authzHeader != null && this.isLoginAttempt(authzHeader);
    }

    protected String getAuthzHeader(ServletRequest request) {
        HttpServletRequest httpRequest = WebUtils.toHttp(request);
        return httpRequest.getHeader(AUTHORIZATION_HEADER);
    }

    protected boolean isLoginAttempt(String authzHeader) {
        String authzScheme = this.getAuthzScheme().toLowerCase();
        return authzHeader.toLowerCase().startsWith(authzScheme);
    }

    protected boolean sendChallenge(ServletRequest request, ServletResponse response) {
        if (log.isDebugEnabled()) {
            log.debug("Authentication required: sending 401 Authentication challenge response.");
        }
        HttpServletResponse httpResponse = WebUtils.toHttp(response);
        httpResponse.setStatus(401);
        String authcHeader = this.getAuthcScheme() + " realm=\"" + this.getApplicationName() + "\"";
        httpResponse.setHeader(AUTHENTICATE_HEADER, authcHeader);
        return false;
    }

    protected AuthenticationToken createToken(ServletRequest request, ServletResponse response) {
        String[] prinCred;
        String authorizationHeader = this.getAuthzHeader(request);
        if (authorizationHeader == null || authorizationHeader.length() == 0) {
            return this.createToken("", "", request, response);
        }
        if (log.isDebugEnabled()) {
            log.debug("Attempting to execute login with headers [" + authorizationHeader + "]");
        }
        if ((prinCred = this.getPrincipalsAndCredentials(authorizationHeader, request)) == null || prinCred.length < 2) {
            String username = prinCred == null || prinCred.length == 0 ? "" : prinCred[0];
            return this.createToken(username, "", request, response);
        }
        String username = prinCred[0];
        String password = prinCred[1];
        return this.createToken(username, password, request, response);
    }

    protected String[] getPrincipalsAndCredentials(String authorizationHeader, ServletRequest request) {
        if (authorizationHeader == null) {
            return null;
        }
        String[] authTokens = authorizationHeader.split(" ");
        if (authTokens == null || authTokens.length < 2) {
            return null;
        }
        return this.getPrincipalsAndCredentials(authTokens[0], authTokens[1]);
    }

    protected String[] getPrincipalsAndCredentials(String scheme, String encoded) {
        String decoded = Base64.decodeToString((String)encoded);
        return decoded.split(":");
    }
}

