/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.session.mgt.quartz;

import org.apache.shiro.session.mgt.SessionValidationScheduler;
import org.apache.shiro.session.mgt.ValidatingSessionManager;
import org.apache.shiro.session.mgt.quartz.QuartzSessionValidationJob;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuartzSessionValidationScheduler
implements SessionValidationScheduler {
    public static final long DEFAULT_SESSION_VALIDATION_INTERVAL = 3600000L;
    private static final String JOB_NAME = "SessionValidationJob";
    private static final Logger LOGGER = LoggerFactory.getLogger(QuartzSessionValidationScheduler.class);
    private Scheduler scheduler;
    private boolean schedulerImplicitlyCreated;
    private boolean enabled;
    private ValidatingSessionManager sessionManager;
    private long sessionValidationInterval = 3600000L;

    public QuartzSessionValidationScheduler() {
    }

    public QuartzSessionValidationScheduler(ValidatingSessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    protected Scheduler getScheduler() throws SchedulerException {
        if (this.scheduler == null) {
            this.scheduler = StdSchedulerFactory.getDefaultScheduler();
            this.schedulerImplicitlyCreated = true;
        }
        return this.scheduler;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public void setSessionManager(ValidatingSessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setSessionValidationInterval(long sessionValidationInterval) {
        this.sessionValidationInterval = sessionValidationInterval;
    }

    public void enableSessionValidation() {
        block6: {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Scheduling session validation job using Quartz with session validation interval of [" + this.sessionValidationInterval + "]ms...");
            }
            try {
                TriggerBuilder triggerBuilder = TriggerBuilder.newTrigger().withIdentity(this.getClass().getName(), "DEFAULT").withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInMilliseconds(this.sessionValidationInterval).withRepeatCount(-1));
                SimpleTrigger trigger = (SimpleTrigger)triggerBuilder.build();
                JobDetail detail = JobBuilder.newJob(QuartzSessionValidationJob.class).withIdentity(JOB_NAME, "DEFAULT").build();
                detail.getJobDataMap().put("sessionManager", (Object)this.sessionManager);
                Scheduler scheduler = this.getScheduler();
                scheduler.scheduleJob(detail, (Trigger)trigger);
                if (this.schedulerImplicitlyCreated) {
                    scheduler.start();
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Successfully started implicitly created Quartz Scheduler instance.");
                    }
                }
                this.enabled = true;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Session validation job successfully scheduled with Quartz.");
                }
            }
            catch (SchedulerException e) {
                if (!LOGGER.isErrorEnabled()) break block6;
                LOGGER.error("Error starting the Quartz session validation job.  Session validation may not occur.", (Throwable)e);
            }
        }
    }

    public void disableSessionValidation() {
        Scheduler scheduler;
        block16: {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Stopping Quartz session validation job...");
            }
            try {
                scheduler = this.getScheduler();
                if (scheduler == null) {
                    if (LOGGER.isWarnEnabled()) {
                        LOGGER.warn("getScheduler() method returned a null Quartz scheduler, which is unexpected.  Please check your configuration and/or implementation.  Returning quietly since there is no validation job to remove (scheduler does not exist).");
                    }
                    return;
                }
            }
            catch (SchedulerException e) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("Unable to acquire Quartz Scheduler.  Ignoring and returning (already stopped?)", (Throwable)e);
                }
                return;
            }
            try {
                scheduler.unscheduleJob(TriggerKey.triggerKey((String)JOB_NAME, (String)"DEFAULT"));
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Quartz session validation job stopped successfully.");
                }
            }
            catch (SchedulerException e) {
                if (!LOGGER.isDebugEnabled()) break block16;
                LOGGER.debug("Could not cleanly remove SessionValidationJob from Quartz scheduler.  Ignoring and stopping.", (Throwable)e);
            }
        }
        this.enabled = false;
        if (this.schedulerImplicitlyCreated) {
            try {
                scheduler.shutdown();
            }
            catch (SchedulerException e) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("Unable to cleanly shutdown implicitly created Quartz Scheduler instance.", (Throwable)e);
                }
            }
            finally {
                this.setScheduler(null);
                this.schedulerImplicitlyCreated = false;
            }
        }
    }
}

