/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.hazelcast.cache;

import com.hazelcast.config.Config;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.map.IMap;
import java.util.Map;
import org.apache.shiro.cache.Cache;
import org.apache.shiro.cache.CacheException;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.cache.MapCache;
import org.apache.shiro.lang.ShiroException;
import org.apache.shiro.lang.util.Destroyable;
import org.apache.shiro.lang.util.Initializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HazelcastCacheManager
implements CacheManager,
Initializable,
Destroyable {
    private static final Logger LOGGER = LoggerFactory.getLogger(HazelcastCacheManager.class);
    private boolean implicitlyCreated;
    private HazelcastInstance hazelcastInstance;
    private Config config;

    public <K, V> Cache<K, V> getCache(String name) throws CacheException {
        IMap map = this.ensureHazelcastInstance().getMap(name);
        return new MapCache(name, (Map)map);
    }

    protected HazelcastInstance ensureHazelcastInstance() {
        if (this.hazelcastInstance == null) {
            this.hazelcastInstance = this.createHazelcastInstance();
            this.implicitlyCreated = true;
        }
        return this.hazelcastInstance;
    }

    public void init() throws ShiroException {
        this.ensureHazelcastInstance();
    }

    protected HazelcastInstance createHazelcastInstance() {
        return Hazelcast.newHazelcastInstance((Config)this.config);
    }

    protected final boolean isImplicitlyCreated() {
        return this.implicitlyCreated;
    }

    public void destroy() throws Exception {
        if (this.implicitlyCreated) {
            try {
                this.hazelcastInstance.getLifecycleService().shutdown();
            }
            catch (Throwable t) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("Unable to cleanly shutdown implicitly created HazelcastInstance.  Ignoring (shutting down)...", t);
                }
            }
            finally {
                this.hazelcastInstance = null;
                this.implicitlyCreated = false;
            }
        }
    }

    public HazelcastInstance getHazelcastInstance() {
        return this.hazelcastInstance;
    }

    public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
        this.hazelcastInstance = hazelcastInstance;
    }

    public Config getConfig() {
        return this.config;
    }

    public void setConfig(Config config) {
        this.config = config;
    }
}

