/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.guice.web;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import javax.inject.Named;
import javax.servlet.ServletContext;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.web.config.ShiroFilterConfiguration;
import org.apache.shiro.web.env.EnvironmentLoaderListener;
import org.apache.shiro.web.env.WebEnvironment;
import org.apache.shiro.web.filter.mgt.FilterChainResolver;
import org.apache.shiro.web.mgt.WebSecurityManager;

@Singleton
class WebGuiceEnvironment
implements WebEnvironment {
    private FilterChainResolver filterChainResolver;
    private ServletContext servletContext;
    private WebSecurityManager securityManager;
    private ShiroFilterConfiguration filterConfiguration;

    @Inject
    WebGuiceEnvironment(FilterChainResolver filterChainResolver, @Named(value="SHIRO") ServletContext servletContext, WebSecurityManager securityManager, ShiroFilterConfiguration filterConfiguration) {
        this.filterChainResolver = filterChainResolver;
        this.servletContext = servletContext;
        this.securityManager = securityManager;
        this.filterConfiguration = filterConfiguration;
        servletContext.setAttribute(EnvironmentLoaderListener.ENVIRONMENT_ATTRIBUTE_KEY, (Object)this);
    }

    public FilterChainResolver getFilterChainResolver() {
        return this.filterChainResolver;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public WebSecurityManager getWebSecurityManager() {
        return this.securityManager;
    }

    public SecurityManager getSecurityManager() {
        return this.securityManager;
    }

    public ShiroFilterConfiguration getShiroFilterConfiguration() {
        return this.filterConfiguration;
    }
}

