/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.guice.web;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import com.google.inject.Injector;
import com.google.inject.Key;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.guice.web.SimpleFilterChain;
import org.apache.shiro.util.PatternMatcher;
import org.apache.shiro.web.filter.mgt.FilterChainResolver;
import org.apache.shiro.web.util.WebUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SimpleFilterChainResolver
implements FilterChainResolver {
    private final Map<String, Key<? extends Filter>[]> chains;
    private final Injector injector;
    private final PatternMatcher patternMatcher;

    SimpleFilterChainResolver(Map<String, Key<? extends Filter>[]> chains, Injector injector, PatternMatcher patternMatcher) {
        this.chains = chains;
        this.injector = injector;
        this.patternMatcher = patternMatcher;
    }

    public FilterChain getChain(ServletRequest request, ServletResponse response, FilterChain originalChain) {
        String path = WebUtils.getPathWithinApplication((HttpServletRequest)WebUtils.toHttp((ServletRequest)request));
        for (String pathPattern : this.chains.keySet()) {
            if (!this.patternMatcher.matches(pathPattern, path)) continue;
            return new SimpleFilterChain(originalChain, Iterators.transform((Iterator)Iterators.forArray((Object[])this.chains.get(pathPattern)), (Function)new Function<Key<? extends Filter>, Filter>(){

                public Filter apply(Key<? extends Filter> input) {
                    return (Filter)SimpleFilterChainResolver.this.injector.getInstance(input);
                }
            }));
        }
        return null;
    }
}

