/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.cache;

import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.shiro.cache.Cache;
import org.apache.shiro.cache.CacheException;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.lang.util.Destroyable;
import org.apache.shiro.lang.util.LifecycleUtils;
import org.apache.shiro.lang.util.StringUtils;

public abstract class AbstractCacheManager
implements CacheManager,
Destroyable {
    private final ConcurrentMap<String, Cache<?, ?>> caches = new ConcurrentHashMap();

    @Override
    public <K, V> Cache<K, V> getCache(String name) throws IllegalArgumentException, CacheException {
        Cache<K, V> existing;
        if (!StringUtils.hasText((String)name)) {
            throw new IllegalArgumentException("Cache name cannot be null or empty.");
        }
        Cache<K, V> cache = (Cache<K, V>)this.caches.get(name);
        if (cache == null && (existing = this.caches.putIfAbsent(name, cache = this.createCache(name))) != null) {
            cache = existing;
        }
        return cache;
    }

    protected abstract <K, V> Cache<K, V> createCache(String var1) throws CacheException;

    public void destroy() throws Exception {
        while (!this.caches.isEmpty()) {
            for (Cache cache : this.caches.values()) {
                LifecycleUtils.destroy((Object)cache);
            }
            this.caches.clear();
        }
    }

    public String toString() {
        Collection values = this.caches.values();
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append(" with ").append(this.caches.size()).append(" cache(s)): [");
        int i = 0;
        for (Cache cache : values) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(cache.toString());
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }
}

