/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.uri;

import com.google.common.collect.Lists;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.auth.SecurityTokenCodec;
import org.apache.shindig.auth.SecurityTokenException;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.uri.UriBuilder;
import org.apache.shindig.config.ContainerConfig;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.UserPrefs;
import org.apache.shindig.gadgets.spec.UserPref;
import org.apache.shindig.gadgets.spec.View;
import org.apache.shindig.gadgets.uri.IframeUriManager;
import org.apache.shindig.gadgets.uri.LockedDomainPrefixGenerator;
import org.apache.shindig.gadgets.uri.UriCommon;
import org.apache.shindig.gadgets.uri.UriStatus;

public class DefaultIframeUriManager
implements IframeUriManager {
    private static final boolean DEFAULT_USE_TEMPLATES = false;
    static final String IFRAME_BASE_PATH_KEY = "gadgets.uri.iframe.basePath";
    static final String LOCKED_DOMAIN_REQUIRED_KEY = "gadgets.uri.iframe.lockedDomainRequired";
    public static final String LOCKED_DOMAIN_SUFFIX_KEY = "gadgets.uri.iframe.lockedDomainSuffix";
    public static final String UNLOCKED_DOMAIN_KEY = "gadgets.uri.iframe.unlockedDomain";
    public static final String SECURITY_TOKEN_ALWAYS_KEY = "gadgets.uri.iframe.alwaysAppendSecurityToken";
    public static final String LOCKED_DOMAIN_FEATURE_NAME = "locked-domain";
    public static final String SECURITY_TOKEN_FEATURE_NAME = "security-token";
    private boolean ldEnabled = true;
    private TemplatingSignal tplSignal = null;
    private IframeUriManager.Versioner versioner = null;
    private final ContainerConfig config;
    private final LockedDomainPrefixGenerator ldGen;
    private final SecurityTokenCodec securityTokenCodec;
    private final List<String> ldSuffixes;

    @Inject
    public DefaultIframeUriManager(ContainerConfig config, LockedDomainPrefixGenerator ldGen, SecurityTokenCodec securityTokenCodec) {
        this.config = config;
        this.ldGen = ldGen;
        this.securityTokenCodec = securityTokenCodec;
        Collection containers = config.getContainers();
        ArrayList ldSuffixes = Lists.newArrayListWithCapacity((int)containers.size());
        for (String container : containers) {
            ldSuffixes.add(this.getReqVal(container, LOCKED_DOMAIN_SUFFIX_KEY));
        }
        this.ldSuffixes = Collections.unmodifiableList(ldSuffixes);
    }

    @Inject(optional=true)
    public void setLockedDomainEnabled(@Named(value="shindig.locked-domain.enabled") Boolean ldEnabled) {
        this.ldEnabled = ldEnabled;
    }

    @Inject(optional=true)
    public void setVersioner(IframeUriManager.Versioner versioner) {
        this.versioner = versioner;
    }

    @Inject(optional=true)
    public void setTemplatingSignal(TemplatingSignal tplSignal) {
        this.tplSignal = tplSignal;
    }

    public Uri makeRenderingUri(Gadget gadget) {
        UriBuilder uri;
        View view = gadget.getCurrentView();
        GadgetContext context = gadget.getContext();
        String container = context.getContainer();
        if (View.ContentType.URL.equals((Object)view.getType())) {
            uri = new UriBuilder(view.getHref());
        } else {
            uri = new UriBuilder();
            uri.setPath(this.getReqVal(container, IFRAME_BASE_PATH_KEY));
            String host = this.usingLockedDomain(gadget, container) ? this.ldGen.getLockedDomainPrefix(gadget.getSpec().getUrl()) + this.getReqVal(container, LOCKED_DOMAIN_SUFFIX_KEY) : this.getReqVal(container, UNLOCKED_DOMAIN_KEY);
            uri.setAuthority(host);
            uri.setScheme(this.getScheme(gadget, container));
            uri.addQueryParameter(UriCommon.Param.URL.getKey(), context.getUrl().toString());
        }
        uri.addQueryParameter(UriCommon.Param.CONTAINER.getKey(), container);
        boolean useTpl = this.tplSignal != null ? this.tplSignal.useTemplates() : false;
        this.addParam(uri, UriCommon.Param.VIEW.getKey(), view.getName(), useTpl, false);
        this.addParam(uri, UriCommon.Param.LANG.getKey(), context.getLocale().getLanguage(), useTpl, false);
        this.addParam(uri, UriCommon.Param.COUNTRY.getKey(), context.getLocale().getCountry(), useTpl, false);
        this.addParam(uri, UriCommon.Param.DEBUG.getKey(), context.getDebug() ? "1" : "0", useTpl, false);
        this.addParam(uri, UriCommon.Param.NO_CACHE.getKey(), context.getIgnoreCache() ? "1" : "0", useTpl, false);
        UserPrefs prefs = context.getUserPrefs();
        for (UserPref up : gadget.getSpec().getUserPrefs().values()) {
            String name = up.getName();
            String data = prefs.getPref(name);
            if (data == null) {
                data = up.getDefaultValue();
            }
            boolean upInFragment = !view.needsUserPrefSubstitution();
            this.addParam(uri, "up_" + up.getName(), data, useTpl, upInFragment);
        }
        if (this.versioner != null) {
            this.addParam(uri, UriCommon.Param.VERSION.getKey(), this.versioner.version(gadget.getSpec().getUrl(), container), false, false);
        }
        if (this.wantsSecurityToken(gadget)) {
            boolean securityTokenOnQuery = this.isTokenNeededForRendering(gadget);
            String securityToken = this.generateSecurityToken(gadget);
            this.addParam(uri, UriCommon.Param.SECURITY_TOKEN.getKey(), securityToken, securityToken == null, !securityTokenOnQuery);
        }
        this.addExtras(uri);
        return uri.toUri();
    }

    protected String generateSecurityToken(Gadget gadget) {
        try {
            SecurityToken token = gadget.getContext().getToken();
            if (this.securityTokenCodec != null && token != null) {
                return this.securityTokenCodec.encodeToken(token);
            }
        }
        catch (SecurityTokenException securityTokenException) {
            // empty catch block
        }
        return null;
    }

    protected boolean wantsSecurityToken(Gadget gadget) {
        return gadget.getAllFeatures().contains(SECURITY_TOKEN_FEATURE_NAME) || this.config.getBool(gadget.getContext().getContainer(), SECURITY_TOKEN_ALWAYS_KEY);
    }

    protected boolean isTokenNeededForRendering(Gadget gadget) {
        return true;
    }

    public UriStatus validateRenderingUri(Uri inUri) {
        UriBuilder uri = new UriBuilder(inUri);
        String gadgetStr = uri.getQueryParameter(UriCommon.Param.URL.getKey());
        Uri gadgetUri = null;
        try {
            gadgetUri = Uri.parse((String)gadgetStr);
        }
        catch (Exception e) {
            return UriStatus.BAD_URI;
        }
        String container = uri.getQueryParameter(UriCommon.Param.CONTAINER.getKey());
        if (container == null) {
            container = "default";
        }
        String host = uri.getAuthority().toLowerCase();
        String gadgetLdPrefix = this.ldGen.getLockedDomainPrefix(gadgetUri).toLowerCase();
        if (this.ldEnabled && !this.lockedDomainExclusion()) {
            if (host.startsWith(gadgetLdPrefix)) {
                host = host.substring(gadgetLdPrefix.length());
                String ldSuffix = this.getReqVal(container, LOCKED_DOMAIN_SUFFIX_KEY);
                if (!ldSuffix.equalsIgnoreCase(host)) {
                    return UriStatus.INVALID_DOMAIN;
                }
            } else {
                for (String ldSuffix : this.ldSuffixes) {
                    if (!host.endsWith(ldSuffix)) continue;
                    return UriStatus.INVALID_DOMAIN;
                }
            }
        }
        String version = uri.getQueryParameter(UriCommon.Param.VERSION.getKey());
        if (this.versioner == null || version == null) {
            return UriStatus.VALID_UNVERSIONED;
        }
        return this.versioner.validate(gadgetUri, container, version);
    }

    public static String tplKey(String key) {
        return '%' + key + '%';
    }

    protected boolean lockedDomainExclusion() {
        return false;
    }

    protected String getScheme(Gadget gadget, String container) {
        return null;
    }

    protected void addExtras(UriBuilder uri) {
    }

    private void addParam(UriBuilder uri, String key, String data, boolean templated, boolean fragment) {
        String value = templated ? DefaultIframeUriManager.tplKey(key) : data;
        if (!fragment) {
            uri.addQueryParameter(key, value);
        } else {
            uri.addFragmentParameter(key, value);
        }
    }

    private boolean usingLockedDomain(Gadget gadget, String container) {
        if (!this.ldEnabled) {
            return false;
        }
        if (this.lockedDomainExclusion()) {
            return false;
        }
        if (this.config.getBool(container, LOCKED_DOMAIN_REQUIRED_KEY)) {
            return true;
        }
        return gadget.getAllFeatures().contains(LOCKED_DOMAIN_FEATURE_NAME);
    }

    private String getReqVal(String container, String key) {
        String val = this.config.getString(container, key);
        if (val == null) {
            throw new RuntimeException("Missing required container config param, key: " + key + ", container: " + container);
        }
        return val;
    }

    public static final class DefaultTemplatingSignal
    implements TemplatingSignal {
        private boolean useTemplates = true;

        @Inject(optional=true)
        public void setUseTemplates(@Named(value="shindig.urlgen.use-templates-default") Boolean useTemplates) {
            this.useTemplates = useTemplates;
        }

        public boolean useTemplates() {
            return this.useTemplates;
        }
    }

    @ImplementedBy(value=DefaultTemplatingSignal.class)
    public static interface TemplatingSignal {
        public boolean useTemplates();
    }
}

