/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.spec;

import org.apache.shindig.common.xml.XmlUtil;
import org.apache.shindig.gadgets.spec.SpecParserException;
import org.apache.shindig.gadgets.variables.Substitutions;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Icon {
    private final String mode;
    private final String type;
    private String content;

    public String getMode() {
        return this.mode;
    }

    public String getType() {
        return this.type;
    }

    public String getContent() {
        return this.content;
    }

    public Icon substitute(Substitutions substituter) {
        Icon icon = new Icon(this);
        icon.content = substituter.substituteString(this.content);
        return icon;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(32 + this.type.length() + this.content.length());
        buf.append("<Icon type='").append(this.type).append('\'');
        if (this.mode != null) {
            buf.append(" mode='").append(this.mode).append('\'');
        }
        buf.append('>').append(this.content).append("</Icon>");
        return buf.toString();
    }

    public Icon(Element element) throws SpecParserException {
        this.mode = XmlUtil.getAttribute((Node)element, (String)"mode");
        if (this.mode != null && !this.mode.equals("base64")) {
            throw new SpecParserException("The only valid value for Icon@mode is \"base64\"");
        }
        this.type = XmlUtil.getAttribute((Node)element, (String)"type", (String)"");
        this.content = element.getTextContent();
    }

    private Icon(Icon icon) {
        this.mode = icon.mode;
        this.type = icon.type;
    }
}

