/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.servlet;

import com.google.inject.Inject;
import java.io.IOException;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.shindig.common.servlet.HttpUtil;
import org.apache.shindig.common.servlet.InjectedServlet;
import org.apache.shindig.common.uri.UriBuilder;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.servlet.JsHandler;
import org.apache.shindig.gadgets.uri.JsUriManager;
import org.apache.shindig.gadgets.uri.UriStatus;

public class JsServlet
extends InjectedServlet {
    private static final long serialVersionUID = 6255917470412008175L;
    static final String ONLOAD_JS_TPL = "(function() {var nm='%s';if (typeof window[nm]==='function') {window[nm]();}})();";
    private static final Pattern ONLOAD_FN_PATTERN = Pattern.compile("[a-zA-Z0-9_]+");
    private transient JsHandler jsHandler;
    private transient JsUriManager jsUriManager;

    @Inject
    public void setJsHandler(JsHandler jsHandler) {
        this.checkInitialized();
        this.jsHandler = jsHandler;
    }

    @Inject
    public void setUrlGenerator(JsUriManager jsUriManager) {
        this.checkInitialized();
        this.jsUriManager = jsUriManager;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        UriStatus vstatus = null;
        try {
            vstatus = this.jsUriManager.processExternJsUri(new UriBuilder(req).toUri()).getStatus();
        }
        catch (GadgetException e) {
            resp.sendError(e.getHttpStatusCode(), e.getMessage());
            return;
        }
        if (req.getHeader("If-Modified-Since") != null && vstatus == UriStatus.VALID_VERSIONED) {
            resp.setStatus(304);
            return;
        }
        JsHandler.JsHandlerResponse handlerResponse = this.jsHandler.getJsContent(req);
        StringBuilder jsData = handlerResponse.getJsData();
        boolean isProxyCacheable = handlerResponse.isProxyCacheable();
        String onloadStr = req.getParameter("onload");
        if (onloadStr != null) {
            if (!ONLOAD_FN_PATTERN.matcher(onloadStr).matches()) {
                resp.sendError(400, "Invalid onload callback specified");
                return;
            }
            jsData.append(String.format(ONLOAD_JS_TPL, StringEscapeUtils.escapeJavaScript((String)onloadStr)));
        }
        if (jsData.length() == 0) {
            resp.setStatus(404);
            return;
        }
        this.postJsContentProcessing(resp, vstatus, isProxyCacheable);
        resp.setContentType("text/javascript; charset=utf-8");
        byte[] response = jsData.toString().getBytes("UTF-8");
        resp.setContentLength(response.length);
        resp.getOutputStream().write(response);
    }

    protected void postJsContentProcessing(HttpServletResponse resp, UriStatus vstatus, boolean isProxyCacheable) {
        switch (vstatus) {
            case VALID_VERSIONED: {
                HttpUtil.setCachingHeaders((HttpServletResponse)resp, (!isProxyCacheable ? 1 : 0) != 0);
                break;
            }
            case VALID_UNVERSIONED: {
                HttpUtil.setCachingHeaders((HttpServletResponse)resp, (int)3600, (!isProxyCacheable ? 1 : 0) != 0);
                break;
            }
            case INVALID_VERSION: {
                HttpUtil.setNoCache((HttpServletResponse)resp);
            }
        }
    }
}

