/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import com.google.inject.Inject;
import java.util.List;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.rewrite.ContentRewriterFeature;
import org.apache.shindig.gadgets.rewrite.CssResponseRewriter;
import org.apache.shindig.gadgets.rewrite.DomWalker;
import org.apache.shindig.gadgets.rewrite.RewritingException;
import org.apache.shindig.gadgets.uri.ProxyUriManager;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StyleTagProxyEmbeddedUrlsVisitor
implements DomWalker.Visitor {
    protected final ContentRewriterFeature.Config config;
    protected final ProxyUriManager proxyUriManager;
    protected final CssResponseRewriter cssRewriter;

    @Inject
    public StyleTagProxyEmbeddedUrlsVisitor(ContentRewriterFeature.Config config, ProxyUriManager proxyUriManager, CssResponseRewriter cssRewriter) {
        this.config = config;
        this.proxyUriManager = proxyUriManager;
        this.cssRewriter = cssRewriter;
    }

    @Override
    public DomWalker.Visitor.VisitStatus visit(Gadget gadget, Node node) throws RewritingException {
        if (node.getNodeType() != 1 || !node.getNodeName().equalsIgnoreCase("style")) {
            return DomWalker.Visitor.VisitStatus.BYPASS;
        }
        return DomWalker.Visitor.VisitStatus.RESERVE_NODE;
    }

    @Override
    public boolean revisit(Gadget gadget, List<Node> nodes) throws RewritingException {
        Uri contentBase = gadget.getSpec().getUrl();
        for (Node node : nodes) {
            Element elem = (Element)node;
            this.cssRewriter.rewrite(elem, contentBase, CssResponseRewriter.uriMaker(this.proxyUriManager, this.config), false, gadget.getContext());
        }
        return !nodes.isEmpty();
    }
}

