/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.protocol.conversion;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.apache.shindig.common.xml.XmlUtil;
import org.apache.shindig.protocol.conversion.BeanXmlConverter;
import org.apache.shindig.protocol.model.Model;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.ElementQualifier;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.examples.RecursiveElementNameAndTextQualifier;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BeanXmlConverterTest
extends Assert {
    private Model.Car car;
    private BeanXmlConverter beanXmlConverter;

    @Before
    public void setUp() throws Exception {
        this.car = new Model.Car();
        this.beanXmlConverter = new BeanXmlConverter();
    }

    @Test
    public void testCarToXml() throws Exception {
        String xml = this.beanXmlConverter.convertToXml((Object)this.car);
        XMLUnit.setIgnoreWhitespace((boolean)true);
        Diff diff = new Diff("<response><engine><EnumImpl><value><declaringClass>org.apache.shindig.protocol.model.Model$Engine</declaringClass><displayValue>Gas</displayValue></value></EnumImpl><EnumImpl><value><declaringClass>org.apache.shindig.protocol.model.Model$Engine</declaringClass><displayValue>Hybrid</displayValue></value></EnumImpl></engine><parkingTickets><entry><key>TOKYO</key><value>250Y</value></entry><entry><key>BERKELEY</key><value>$120</value></entry></parkingTickets><passengers><ModelPassenger><gender><declaringClass>org.apache.shindig.protocol.model.Model$Gender</declaringClass></gender><name>Dick Dastardly</name></ModelPassenger><ModelPassenger><gender><declaringClass>org.apache.shindig.protocol.model.Model$Gender</declaringClass></gender><name>Speed Racer</name></ModelPassenger></passengers></response>", xml);
        diff.overrideElementQualifier((ElementQualifier)new RecursiveElementNameAndTextQualifier());
        XMLAssert.assertXMLEqual((Diff)diff, (boolean)true);
    }

    @Test
    public void testMapsToXml() throws Exception {
        TreeMap map = Maps.newTreeMap();
        ImmutableMap item1Map = ImmutableMap.of((Object)"value", (Object)"1");
        map.put("item1", item1Map);
        ImmutableMap item2Map = ImmutableMap.of((Object)"value", (Object)"2");
        map.put("item2", item2Map);
        String xml = this.beanXmlConverter.convertToXml((Object)map);
        XmlUtil.parse((String)xml);
        String expectedXml = "<response><empty>false</empty><entry><key>item1</key><value><empty>false</empty><entry><key>value</key><value>1</value></entry></value></entry><entry><key>item2</key><value><empty>false</empty><entry><key>value</key><value>2</value></entry></value></entry></response>";
        BeanXmlConverterTest.assertEquals((Object)expectedXml, (Object)StringUtils.deleteWhitespace((String)xml));
    }
}

