/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.protocol;

import java.util.Set;
import org.apache.shindig.protocol.ContentTypes;
import org.junit.Assert;
import org.junit.Test;

public class ContentTypesTest
extends Assert {
    @Test
    public void testAllowJson() throws Exception {
        ContentTypes.checkContentTypes((Set)ContentTypes.ALLOWED_JSON_CONTENT_TYPES, (String)"application/json");
    }

    @Test
    public void testAllowJsonRpc() throws Exception {
        ContentTypes.checkContentTypes((Set)ContentTypes.ALLOWED_JSON_CONTENT_TYPES, (String)"application/json-rpc");
    }

    @Test
    public void testAllowAtom() throws Exception {
        ContentTypes.checkContentTypes((Set)ContentTypes.ALLOWED_ATOM_CONTENT_TYPES, (String)"application/atom+xml");
    }

    @Test
    public void testAllowXml() throws Exception {
        ContentTypes.checkContentTypes((Set)ContentTypes.ALLOWED_XML_CONTENT_TYPES, (String)"application/xml");
    }

    @Test
    public void testAllowMultipart() throws Exception {
        ContentTypes.checkContentTypes((Set)ContentTypes.ALLOWED_MULTIPART_CONTENT_TYPES, (String)"multipart/form-data");
    }

    @Test(expected=ContentTypes.InvalidContentTypeException.class)
    public void testForbidden() throws Exception {
        ContentTypes.checkContentTypes((Set)ContentTypes.ALLOWED_JSON_CONTENT_TYPES, (String)"application/x-www-form-urlencoded");
    }

    @Test(expected=ContentTypes.InvalidContentTypeException.class)
    public void testStrictDisallowUnknown() throws Exception {
        ContentTypes.checkContentTypes((Set)ContentTypes.ALLOWED_JSON_CONTENT_TYPES, (String)"text/plain");
    }

    @Test
    public void textExtractMimePart() throws Exception {
        ContentTypesTest.assertEquals((Object)"text/xml", (Object)ContentTypes.extractMimePart((String)"Text/Xml ; charset = ISO-8859-1;x=y"));
    }
}

