/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.common.xml;

import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.xml.XmlException;
import org.apache.shindig.common.xml.XmlUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XmlUtilTest {
    private static final String STRING_ATTR = "string";
    private static final String STRING_VALUE = "some string value";
    private static final String INT_ATTR = "int";
    private static final int INT_VALUE = 10;
    private static final String BOOL_TRUE_ATTR = "bool-true";
    private static final String BOOL_FALSE_ATTR = "bool-false";
    private static final String URI_ATTR = "uri";
    private static final Uri URI_VALUE = Uri.parse((String)"http://example.org/file");
    private static final String URI_MALFORMED_ATTR = "uri-malformed";
    private static final String FAKE_ATTR = "fake";
    private static final String HTTPS_URI_ATTR = "httpsuri";
    private static final Uri HTTPS_URI_VALUE = Uri.parse((String)"https://example.org");
    private static final String FTP_URI_ATTR = "ftpuri";
    private static final Uri FTP_URI_VALUE = Uri.parse((String)"ftp://ftp.example.org");
    private static final String XML = "<Element string='some string value' int='10' bool-true='true' bool-false='false' uri='" + URI_VALUE + "' " + "uri-malformed" + "='$#%$^$^$^$%$%!! ' " + "httpsuri" + "='" + HTTPS_URI_VALUE + "' " + "ftpuri" + "='" + FTP_URI_VALUE + "' " + "/>";
    private Element node;

    @Before
    public void makeElement() throws XmlException {
        this.node = XmlUtil.parse((String)XML);
    }

    @Test
    public void getAttribute() {
        Assert.assertEquals((Object)STRING_VALUE, (Object)XmlUtil.getAttribute((Node)this.node, (String)STRING_ATTR));
        Assert.assertEquals((Object)STRING_VALUE, (Object)XmlUtil.getAttribute((Node)this.node, (String)FAKE_ATTR, (String)STRING_VALUE));
        Assert.assertNull((String)"getAttribute must return null for undefined attributes.", (Object)XmlUtil.getAttribute((Node)this.node, (String)FAKE_ATTR));
    }

    @Test
    public void getIntAttribute() {
        Assert.assertEquals((long)10L, (long)XmlUtil.getIntAttribute((Node)this.node, (String)INT_ATTR));
        Assert.assertEquals((long)10L, (long)XmlUtil.getIntAttribute((Node)this.node, (String)FAKE_ATTR, (int)10));
        Assert.assertEquals((long)10L, (long)XmlUtil.getIntAttribute((Node)this.node, (String)STRING_ATTR, (int)10));
        Assert.assertEquals((String)"getIntAttribute must return 0 for undefined attributes.", (long)0L, (long)XmlUtil.getIntAttribute((Node)this.node, (String)FAKE_ATTR));
    }

    @Test
    public void getBoolAttribute() {
        Assert.assertTrue((boolean)XmlUtil.getBoolAttribute((Node)this.node, (String)BOOL_TRUE_ATTR));
        Assert.assertFalse((boolean)XmlUtil.getBoolAttribute((Node)this.node, (String)BOOL_FALSE_ATTR));
        Assert.assertTrue((boolean)XmlUtil.getBoolAttribute((Node)this.node, (String)FAKE_ATTR, (boolean)true));
        Assert.assertFalse((boolean)XmlUtil.getBoolAttribute((Node)this.node, (String)FAKE_ATTR, (boolean)false));
        Assert.assertFalse((String)"getBoolAttribute must return false for undefined attributes.", (boolean)XmlUtil.getBoolAttribute((Node)this.node, (String)FAKE_ATTR));
    }

    @Test
    public void getUriAttribute() {
        Assert.assertEquals((Object)URI_VALUE, (Object)XmlUtil.getUriAttribute((Node)this.node, (String)URI_ATTR));
        Assert.assertEquals((Object)URI_VALUE, (Object)XmlUtil.getUriAttribute((Node)this.node, (String)FAKE_ATTR, (Uri)URI_VALUE));
        Assert.assertEquals((Object)URI_VALUE, (Object)XmlUtil.getUriAttribute((Node)this.node, (String)URI_MALFORMED_ATTR, (Uri)URI_VALUE));
        Assert.assertNull((String)"getUriAttribute must return null for undefined attributes.", (Object)XmlUtil.getUriAttribute((Node)this.node, (String)FAKE_ATTR));
        Assert.assertEquals((Object)FTP_URI_VALUE, (Object)XmlUtil.getUriAttribute((Node)this.node, (String)FTP_URI_ATTR));
    }

    @Test
    public void testHttpUriAttribute() {
        Assert.assertEquals((Object)HTTPS_URI_VALUE, (Object)XmlUtil.getHttpUriAttribute((Node)this.node, (String)HTTPS_URI_ATTR, null));
        Assert.assertNull((Object)XmlUtil.getHttpUriAttribute((Node)this.node, (String)FTP_URI_ATTR, null));
        Assert.assertEquals((Object)HTTPS_URI_VALUE, (Object)XmlUtil.getHttpUriAttribute((Node)this.node, (String)FTP_URI_ATTR, null, (Uri)HTTPS_URI_VALUE));
    }

    @Test(expected=XmlException.class)
    public void parseBadXmlThrows() throws XmlException {
        XmlUtil.parse((String)"malformed xml");
    }
}

