/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.ssl.pem;

import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import org.springframework.boot.ssl.SslStoreBundle;
import org.springframework.boot.ssl.pem.PemSslStore;
import org.springframework.boot.ssl.pem.PemSslStoreDetails;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class PemSslStoreBundle
implements SslStoreBundle {
    private static final String DEFAULT_ALIAS = "ssl";
    private final KeyStore keyStore;
    private final KeyStore trustStore;

    public PemSslStoreBundle(PemSslStoreDetails keyStoreDetails, PemSslStoreDetails trustStoreDetails) {
        this(keyStoreDetails, trustStoreDetails, null);
    }

    @Deprecated(since="3.2.0", forRemoval=true)
    public PemSslStoreBundle(PemSslStoreDetails keyStoreDetails, PemSslStoreDetails trustStoreDetails, String alias) {
        this.keyStore = PemSslStoreBundle.createKeyStore("key", PemSslStore.load(keyStoreDetails), alias);
        this.trustStore = PemSslStoreBundle.createKeyStore("trust", PemSslStore.load(trustStoreDetails), alias);
    }

    public PemSslStoreBundle(PemSslStore pemKeyStore, PemSslStore pemTrustStore) {
        this(pemKeyStore, pemTrustStore, null);
    }

    private PemSslStoreBundle(PemSslStore pemKeyStore, PemSslStore pemTrustStore, String alias) {
        this.keyStore = PemSslStoreBundle.createKeyStore("key", pemKeyStore, alias);
        this.trustStore = PemSslStoreBundle.createKeyStore("trust", pemTrustStore, alias);
    }

    @Override
    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    @Override
    public String getKeyStorePassword() {
        return null;
    }

    @Override
    public KeyStore getTrustStore() {
        return this.trustStore;
    }

    private static KeyStore createKeyStore(String name, PemSslStore pemSslStore, String alias) {
        if (pemSslStore == null) {
            return null;
        }
        try {
            Assert.notEmpty(pemSslStore.certificates(), "Certificates must not be empty");
            alias = pemSslStore.alias() != null ? pemSslStore.alias() : alias;
            alias = alias != null ? alias : DEFAULT_ALIAS;
            KeyStore store = PemSslStoreBundle.createKeyStore(pemSslStore.type());
            List<X509Certificate> certificates = pemSslStore.certificates();
            PrivateKey privateKey = pemSslStore.privateKey();
            if (privateKey != null) {
                PemSslStoreBundle.addPrivateKey(store, privateKey, alias, pemSslStore.password(), certificates);
            } else {
                PemSslStoreBundle.addCertificates(store, certificates, alias);
            }
            return store;
        }
        catch (Exception ex) {
            throw new IllegalStateException("Unable to create %s store: %s".formatted(name, ex.getMessage()), ex);
        }
    }

    private static KeyStore createKeyStore(String type) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore store = KeyStore.getInstance(StringUtils.hasText(type) ? type : KeyStore.getDefaultType());
        store.load(null);
        return store;
    }

    private static void addPrivateKey(KeyStore keyStore, PrivateKey privateKey, String alias, String keyPassword, List<X509Certificate> certificateChain) throws KeyStoreException {
        keyStore.setKeyEntry(alias, privateKey, keyPassword != null ? keyPassword.toCharArray() : null, (Certificate[])certificateChain.toArray(X509Certificate[]::new));
    }

    private static void addCertificates(KeyStore keyStore, List<X509Certificate> certificates, String alias) throws KeyStoreException {
        for (int index = 0; index < certificates.size(); ++index) {
            String entryAlias = alias + (String)(certificates.size() == 1 ? "" : "-" + index);
            X509Certificate certificate = certificates.get(index);
            keyStore.setCertificateEntry(entryAlias, certificate);
        }
    }

    public String toString() {
        ToStringCreator creator = new ToStringCreator(this);
        creator.append("keyStore.type", this.keyStore != null ? this.keyStore.getType() : "none");
        creator.append("keyStorePassword", null);
        creator.append("trustStore.type", this.trustStore != null ? this.trustStore.getType() : "none");
        return creator.toString();
    }
}

