/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.udp;

import io.netty.channel.ChannelOption;
import io.netty.util.NetUtil;
import java.net.InetSocketAddress;
import java.util.Collections;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;
import reactor.netty.ConnectionObserver;
import reactor.netty.resources.ConnectionProvider;
import reactor.netty.udp.UdpServer;
import reactor.netty.udp.UdpServerConfig;

final class UdpServerBind
extends UdpServer {
    static final UdpServerBind INSTANCE;
    final UdpServerConfig config;
    static final int DEFAULT_PORT;

    UdpServerBind() {
        this.config = new UdpServerConfig(Collections.singletonMap(ChannelOption.AUTO_READ, false), () -> new InetSocketAddress(NetUtil.LOCALHOST, DEFAULT_PORT));
    }

    UdpServerBind(UdpServerConfig config) {
        this.config = config;
    }

    @Override
    public Mono<? extends Connection> bind() {
        UdpServerConfig conf = this.configuration();
        ConnectionObserver observer = this.config.defaultConnectionObserver().then(this.config.connectionObserver());
        Mono<? extends Connection> mono = ConnectionProvider.newConnection().acquire(conf, observer, null, null);
        if (conf.doOnBind() != null) {
            mono = mono.doOnSubscribe(s2 -> conf.doOnBind().accept(conf));
        }
        return mono;
    }

    @Override
    public UdpServerConfig configuration() {
        return this.config;
    }

    @Override
    protected UdpServer duplicate() {
        return new UdpServerBind(new UdpServerConfig(this.config));
    }

    static {
        int port;
        INSTANCE = new UdpServerBind();
        String portStr = null;
        try {
            portStr = System.getenv("PORT");
            port = portStr != null ? Integer.parseInt(portStr) : 12012;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid environment variable [PORT=" + portStr + "].", e);
        }
        DEFAULT_PORT = port;
    }
}

