/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http2.Http2StreamChannel;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import reactor.netty.ReactorNetty;
import reactor.netty.channel.ChannelOperations;
import reactor.netty.http.server.HttpServerMetricsRecorder;
import reactor.netty.http.server.HttpServerOperations;
import reactor.netty.http.server.MicrometerHttpServerMetricsRecorder;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.annotation.Nullable;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

abstract class AbstractHttpServerMetricsHandler
extends ChannelDuplexHandler {
    static final boolean LAST_FLUSH_WHEN_NO_READ = Boolean.parseBoolean(System.getProperty("reactor.netty.http.server.lastFlushWhenNoRead", "false"));
    private static final Logger log = Loggers.getLogger(AbstractHttpServerMetricsHandler.class);
    boolean channelActivated;
    boolean channelOpened;
    ContextView contextView;
    long dataReceived;
    long dataReceivedTime;
    long dataSent;
    long dataSentTime;
    boolean initialized;
    boolean isHttp11;
    String method;
    String path;
    SocketAddress remoteSocketAddress;
    String status;
    final Function<String, String> methodTagValue;
    final Function<String, String> uriTagValue;
    static final Set<String> STANDARD_METHODS;
    static final String UNKNOWN_METHOD = "UNKNOWN";
    static final Function<String, String> DEFAULT_METHOD_TAG_VALUE;

    protected AbstractHttpServerMetricsHandler(@Nullable Function<String, String> methodTagValue, @Nullable Function<String, String> uriTagValue) {
        this.methodTagValue = methodTagValue == null ? DEFAULT_METHOD_TAG_VALUE : methodTagValue;
        this.uriTagValue = uriTagValue;
    }

    protected AbstractHttpServerMetricsHandler(AbstractHttpServerMetricsHandler copy) {
        this.channelActivated = copy.channelActivated;
        this.channelOpened = copy.channelOpened;
        this.contextView = copy.contextView;
        this.dataReceived = copy.dataReceived;
        this.dataReceivedTime = copy.dataReceivedTime;
        this.dataSent = copy.dataSent;
        this.dataSentTime = copy.dataSentTime;
        this.initialized = copy.initialized;
        this.isHttp11 = copy.isHttp11;
        this.method = copy.method;
        this.path = copy.path;
        this.remoteSocketAddress = copy.remoteSocketAddress;
        this.status = copy.status;
        this.methodTagValue = copy.methodTagValue;
        this.uriTagValue = copy.uriTagValue;
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) {
        block4: {
            if (!(ctx.channel() instanceof Http2StreamChannel)) {
                this.isHttp11 = true;
                if (this.recorder() instanceof MicrometerHttpServerMetricsRecorder) {
                    try {
                        this.channelOpened = true;
                        this.recorder().recordServerConnectionOpened(ctx.channel().localAddress());
                    }
                    catch (RuntimeException e) {
                        if (!log.isWarnEnabled()) break block4;
                        log.warn(ReactorNetty.format(ctx.channel(), "Exception caught while recording metrics."), e);
                    }
                }
            }
        }
        ctx.fireChannelActive();
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) {
        block4: {
            if (!(ctx.channel() instanceof Http2StreamChannel) && this.recorder() instanceof MicrometerHttpServerMetricsRecorder) {
                try {
                    if (this.channelOpened) {
                        this.channelOpened = false;
                        this.recorder().recordServerConnectionClosed(ctx.channel().localAddress());
                    }
                }
                catch (RuntimeException e) {
                    if (!log.isWarnEnabled()) break block4;
                    log.warn(ReactorNetty.format(ctx.channel(), "Exception caught while recording metrics."), e);
                }
            }
        }
        this.recordInactiveConnectionOrStream(ctx.channel());
        ctx.fireChannelInactive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        try {
            if (msg instanceof HttpResponse) {
                if (((HttpResponse)msg).status().equals(HttpResponseStatus.CONTINUE)) {
                    ctx.write(msg, promise);
                    return;
                }
                ChannelOperations<?, ?> channelOps = ChannelOperations.get(ctx.channel());
                if (channelOps instanceof HttpServerOperations) {
                    HttpServerOperations ops = (HttpServerOperations)channelOps;
                    if (!this.initialized) {
                        this.method = this.methodTagValue.apply(ops.method().name());
                        this.path = this.uriTagValue == null ? ops.path : this.uriTagValue.apply(ops.path);
                        this.remoteSocketAddress = ops.remoteSocketAddress();
                        this.initialized = true;
                    }
                    if (this.contextView == null) {
                        this.contextView(ops);
                    }
                    this.status = ops.status().codeAsText().toString();
                    this.startWrite(ops);
                }
            }
            this.dataSent += AbstractHttpServerMetricsHandler.extractProcessedDataFromBuffer(msg);
            if (msg instanceof LastHttpContent) {
                MetricsArgProvider copy;
                if (this.isHttp11 && LAST_FLUSH_WHEN_NO_READ) {
                    copy = this.createMetricsArgProvider();
                    this.recordInactiveConnectionOrStream(ctx.channel());
                } else {
                    copy = null;
                }
                promise.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> {
                    block5: {
                        try {
                            if (copy == null) {
                                this.recordWrite(ctx.channel());
                            } else {
                                this.recordWrite(ctx.channel(), copy);
                            }
                        }
                        catch (RuntimeException e) {
                            if (!log.isWarnEnabled()) break block5;
                            log.warn(ReactorNetty.format(ctx.channel(), "Exception caught while recording metrics."), e);
                        }
                    }
                    if (copy == null) {
                        this.recordInactiveConnectionOrStream(ctx.channel());
                    }
                }));
            }
        }
        catch (RuntimeException e) {
            if (log.isWarnEnabled()) {
                log.warn(ReactorNetty.format(ctx.channel(), "Exception caught while recording metrics."), e);
            }
        }
        finally {
            ctx.write(msg, promise);
        }
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        HttpServerOperations ops;
        block8: {
            ops = null;
            try {
                if (msg instanceof HttpRequest) {
                    this.reset(ctx.channel());
                    ChannelOperations<?, ?> channelOps = ChannelOperations.get(ctx.channel());
                    if (channelOps instanceof HttpServerOperations) {
                        ops = (HttpServerOperations)channelOps;
                        this.method = this.methodTagValue.apply(ops.method().name());
                        this.path = this.uriTagValue == null ? ops.path : this.uriTagValue.apply(ops.path);
                        this.remoteSocketAddress = ops.remoteSocketAddress();
                        this.initialized = true;
                        this.startRead(ops);
                    }
                    this.channelActivated = true;
                    if (ctx.channel() instanceof Http2StreamChannel) {
                        this.recordOpenStream(ctx.channel().localAddress());
                    } else {
                        this.recordActiveConnection(ctx.channel().localAddress());
                    }
                }
                this.dataReceived += AbstractHttpServerMetricsHandler.extractProcessedDataFromBuffer(msg);
                if (msg instanceof LastHttpContent) {
                    this.recordRead();
                }
            }
            catch (RuntimeException e) {
                if (!log.isWarnEnabled()) break block8;
                log.warn(ReactorNetty.format(ctx.channel(), "Exception caught while recording metrics."), e);
            }
        }
        ctx.fireChannelRead(msg);
        if (ops != null) {
            this.contextView(ops);
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        block2: {
            try {
                this.recordException();
            }
            catch (RuntimeException e) {
                if (!log.isWarnEnabled()) break block2;
                log.warn(ReactorNetty.format(ctx.channel(), "Exception caught while recording metrics."), e);
            }
        }
        ctx.fireExceptionCaught(cause);
    }

    private static long extractProcessedDataFromBuffer(Object msg) {
        if (msg instanceof ByteBufHolder) {
            return ((ByteBufHolder)msg).content().readableBytes();
        }
        if (msg instanceof ByteBuf) {
            return ((ByteBuf)msg).readableBytes();
        }
        return 0L;
    }

    protected abstract HttpServerMetricsRecorder recorder();

    protected MetricsArgProvider createMetricsArgProvider() {
        return new MetricsArgProvider(this.contextView, this.dataReceivedTime, this.dataSent, this.dataSentTime, this.method, this.path, this.remoteSocketAddress, this.status);
    }

    protected void contextView(HttpServerOperations ops) {
        this.contextView = Context.empty();
    }

    protected void recordException() {
        this.recorder().incrementErrorsCount(this.remoteSocketAddress, this.path);
    }

    protected void recordRead() {
        this.recorder().recordDataReceivedTime(this.path, this.method, Duration.ofNanos(System.nanoTime() - this.dataReceivedTime));
        this.recorder().recordDataReceived(this.remoteSocketAddress, this.path, this.dataReceived);
    }

    protected void recordWrite(Channel channel) {
        this.recordWrite(this.dataReceivedTime, this.dataSent, this.dataSentTime, this.method, this.path, this.remoteSocketAddress, this.status);
    }

    protected void recordWrite(Channel channel, MetricsArgProvider metricsArgProvider) {
        this.recordWrite(metricsArgProvider.dataReceivedTime, metricsArgProvider.dataSent, metricsArgProvider.dataSentTime, metricsArgProvider.method, metricsArgProvider.path, metricsArgProvider.remoteSocketAddress, metricsArgProvider.status);
    }

    void recordWrite(long dataReceivedTime, long dataSent, long dataSentTime, String method, String path, SocketAddress remoteSocketAddress, String status) {
        Duration dataSentTimeDuration = Duration.ofNanos(System.nanoTime() - dataSentTime);
        this.recorder().recordDataSentTime(path, method, status, dataSentTimeDuration);
        if (dataReceivedTime != 0L) {
            this.recorder().recordResponseTime(path, method, status, Duration.ofNanos(System.nanoTime() - dataReceivedTime));
        } else {
            this.recorder().recordResponseTime(path, method, status, dataSentTimeDuration);
        }
        this.recorder().recordDataSent(remoteSocketAddress, path, dataSent);
    }

    protected void recordActiveConnection(SocketAddress localAddress) {
        this.recorder().recordServerConnectionActive(localAddress);
    }

    protected void recordInactiveConnection(SocketAddress localAddress) {
        this.recorder().recordServerConnectionInactive(localAddress);
    }

    protected void recordOpenStream(SocketAddress localAddress) {
        this.recorder().recordStreamOpened(localAddress);
    }

    protected void recordClosedStream(SocketAddress localAddress) {
        this.recorder().recordStreamClosed(localAddress);
    }

    protected void startRead(HttpServerOperations ops) {
        this.dataReceivedTime = System.nanoTime();
    }

    protected void startWrite(HttpServerOperations ops) {
        this.dataSentTime = System.nanoTime();
    }

    void recordInactiveConnectionOrStream(Channel channel) {
        block5: {
            if (this.channelActivated) {
                this.channelActivated = false;
                try {
                    if (channel instanceof Http2StreamChannel) {
                        this.recordClosedStream(channel.localAddress());
                    } else {
                        this.recordInactiveConnection(channel.localAddress());
                    }
                }
                catch (RuntimeException e) {
                    if (!log.isWarnEnabled()) break block5;
                    log.warn(ReactorNetty.format(channel, "Exception caught while recording metrics."), e);
                }
            }
        }
    }

    protected void reset(Channel channel) {
        this.contextView = null;
        this.dataReceived = 0L;
        this.dataReceivedTime = 0L;
        this.dataSent = 0L;
        this.dataSentTime = 0L;
        this.initialized = false;
        this.method = null;
        this.path = null;
        this.remoteSocketAddress = null;
        this.status = null;
    }

    static {
        HashSet<String> standardMethods = new HashSet<String>();
        standardMethods.add("GET");
        standardMethods.add("HEAD");
        standardMethods.add("POST");
        standardMethods.add("PUT");
        standardMethods.add("PATCH");
        standardMethods.add("DELETE");
        standardMethods.add("OPTIONS");
        standardMethods.add("TRACE");
        standardMethods.add("CONNECT");
        STANDARD_METHODS = Collections.unmodifiableSet(standardMethods);
        DEFAULT_METHOD_TAG_VALUE = m4 -> STANDARD_METHODS.contains(m4) ? m4 : UNKNOWN_METHOD;
    }

    static class MetricsArgProvider {
        final ContextView contextView;
        final long dataReceivedTime;
        final long dataSent;
        final long dataSentTime;
        final Map<Object, Object> map = new HashMap<Object, Object>();
        final String method;
        final String path;
        final SocketAddress remoteSocketAddress;
        final String status;

        MetricsArgProvider(ContextView contextView, long dataReceivedTime, long dataSent, long dataSentTime, String method, String path, SocketAddress remoteSocketAddress, String status) {
            this.contextView = contextView;
            this.dataReceivedTime = dataReceivedTime;
            this.dataSent = dataSent;
            this.dataSentTime = dataSentTime;
            this.method = method;
            this.path = path;
            this.remoteSocketAddress = remoteSocketAddress;
            this.status = status;
        }

        <T> MetricsArgProvider put(Object key, T object) {
            this.map.put(key, object);
            return this;
        }

        @Nullable
        <T> T get(Object key) {
            return (T)this.map.get(key);
        }
    }
}

