/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.support;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.TypeConverter;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;

public abstract class ReflectionHelper {
    @Nullable
    static ArgumentsMatchInfo compareArguments(List<TypeDescriptor> expectedArgTypes, List<TypeDescriptor> suppliedArgTypes, TypeConverter typeConverter) {
        Assert.isTrue(expectedArgTypes.size() == suppliedArgTypes.size(), "Expected argument types and supplied argument types should be arrays of same length");
        ArgumentsMatchKind match = ArgumentsMatchKind.EXACT;
        for (int i = 0; i < expectedArgTypes.size() && match != null; ++i) {
            TypeDescriptor suppliedArg = suppliedArgTypes.get(i);
            TypeDescriptor expectedArg = expectedArgTypes.get(i);
            if (suppliedArg == null) {
                if (!expectedArg.isPrimitive()) continue;
                match = null;
                continue;
            }
            if (expectedArg.equals(suppliedArg)) continue;
            if (suppliedArg.isAssignableTo(expectedArg)) {
                if (match == ArgumentsMatchKind.REQUIRES_CONVERSION) continue;
                match = ArgumentsMatchKind.CLOSE;
                continue;
            }
            match = typeConverter.canConvert(suppliedArg, expectedArg) ? ArgumentsMatchKind.REQUIRES_CONVERSION : null;
        }
        return match != null ? new ArgumentsMatchInfo(match) : null;
    }

    public static int getTypeDifferenceWeight(List<TypeDescriptor> paramTypes, List<TypeDescriptor> argTypes) {
        int result = 0;
        for (int i = 0; i < paramTypes.size(); ++i) {
            TypeDescriptor argType;
            TypeDescriptor paramType = paramTypes.get(i);
            TypeDescriptor typeDescriptor = argType = i < argTypes.size() ? argTypes.get(i) : null;
            if (argType == null) {
                if (!paramType.isPrimitive()) continue;
                return Integer.MAX_VALUE;
            }
            Class<Object> paramTypeClazz = paramType.getType();
            if (!ClassUtils.isAssignable(paramTypeClazz, argType.getType())) {
                return Integer.MAX_VALUE;
            }
            if (paramTypeClazz.isPrimitive()) {
                paramTypeClazz = Object.class;
            }
            Class<?> superClass = argType.getType().getSuperclass();
            while (superClass != null) {
                if (paramTypeClazz.equals(superClass)) {
                    result += 2;
                    superClass = null;
                    continue;
                }
                if (ClassUtils.isAssignable(paramTypeClazz, superClass)) {
                    result += 2;
                    superClass = superClass.getSuperclass();
                    continue;
                }
                superClass = null;
            }
            if (!paramTypeClazz.isInterface()) continue;
            ++result;
        }
        return result;
    }

    @Nullable
    static ArgumentsMatchInfo compareArgumentsVarargs(List<TypeDescriptor> expectedArgTypes, List<TypeDescriptor> suppliedArgTypes, TypeConverter typeConverter) {
        Assert.isTrue(!CollectionUtils.isEmpty(expectedArgTypes), "Expected arguments must at least include one array (the varargs parameter)");
        Assert.isTrue(expectedArgTypes.get(expectedArgTypes.size() - 1).isArray(), "Final expected argument should be array type (the varargs parameter)");
        ArgumentsMatchKind match = ArgumentsMatchKind.EXACT;
        int argCountUpToVarargs = expectedArgTypes.size() - 1;
        for (int i = 0; i < argCountUpToVarargs && match != null; ++i) {
            TypeDescriptor suppliedArg = suppliedArgTypes.get(i);
            TypeDescriptor expectedArg = expectedArgTypes.get(i);
            if (suppliedArg == null) {
                if (!expectedArg.isPrimitive()) continue;
                match = null;
                continue;
            }
            if (expectedArg.equals(suppliedArg)) continue;
            if (suppliedArg.isAssignableTo(expectedArg)) {
                if (match == ArgumentsMatchKind.REQUIRES_CONVERSION) continue;
                match = ArgumentsMatchKind.CLOSE;
                continue;
            }
            match = typeConverter.canConvert(suppliedArg, expectedArg) ? ArgumentsMatchKind.REQUIRES_CONVERSION : null;
        }
        if (match == null) {
            return null;
        }
        if (suppliedArgTypes.size() != expectedArgTypes.size() || !expectedArgTypes.get(expectedArgTypes.size() - 1).equals(suppliedArgTypes.get(suppliedArgTypes.size() - 1))) {
            TypeDescriptor varargsDesc = expectedArgTypes.get(expectedArgTypes.size() - 1);
            TypeDescriptor elementDesc = varargsDesc.getElementTypeDescriptor();
            Assert.state(elementDesc != null, "No element type");
            Class<?> varargsParamType = elementDesc.getType();
            for (int i = expectedArgTypes.size() - 1; i < suppliedArgTypes.size(); ++i) {
                TypeDescriptor suppliedArg = suppliedArgTypes.get(i);
                if (suppliedArg == null) {
                    if (!varargsParamType.isPrimitive()) continue;
                    match = null;
                    continue;
                }
                if (varargsParamType == suppliedArg.getType()) continue;
                if (ClassUtils.isAssignable(varargsParamType, suppliedArg.getType())) {
                    if (match == ArgumentsMatchKind.REQUIRES_CONVERSION) continue;
                    match = ArgumentsMatchKind.CLOSE;
                    continue;
                }
                match = typeConverter.canConvert(suppliedArg, TypeDescriptor.valueOf(varargsParamType)) ? ArgumentsMatchKind.REQUIRES_CONVERSION : null;
            }
        }
        return match != null ? new ArgumentsMatchInfo(match) : null;
    }

    public static boolean convertAllArguments(TypeConverter converter, Object[] arguments, Method method) throws SpelEvaluationException {
        Integer varargsPosition = method.isVarArgs() ? Integer.valueOf(method.getParameterCount() - 1) : null;
        return ReflectionHelper.convertArguments(converter, arguments, method, varargsPosition);
    }

    static boolean convertArguments(TypeConverter converter, Object[] arguments, Executable executable, @Nullable Integer varargsPosition) throws EvaluationException {
        boolean conversionOccurred;
        block8: {
            MethodParameter methodParam;
            TypeDescriptor targetType;
            block9: {
                block7: {
                    conversionOccurred = false;
                    if (varargsPosition != null) break block7;
                    for (int i = 0; i < arguments.length; ++i) {
                        TypeDescriptor targetType2 = new TypeDescriptor(MethodParameter.forExecutable(executable, i));
                        Object argument = arguments[i];
                        arguments[i] = converter.convertValue(argument, TypeDescriptor.forObject(argument), targetType2);
                        conversionOccurred |= argument != arguments[i];
                    }
                    break block8;
                }
                for (int i = 0; i < varargsPosition; ++i) {
                    targetType = new TypeDescriptor(MethodParameter.forExecutable(executable, i));
                    Object argument = arguments[i];
                    arguments[i] = converter.convertValue(argument, TypeDescriptor.forObject(argument), targetType);
                    conversionOccurred |= argument != arguments[i];
                }
                methodParam = MethodParameter.forExecutable(executable, varargsPosition);
                if (varargsPosition != arguments.length - 1) break block9;
                Object argument = arguments[varargsPosition];
                TypeDescriptor targetType3 = new TypeDescriptor(methodParam);
                TypeDescriptor sourceType = TypeDescriptor.forObject(argument);
                if (argument == null) {
                    TypeDescriptor elementDesc = targetType3.getElementTypeDescriptor();
                    if (elementDesc != null && elementDesc.getObjectType() == Optional.class) {
                        arguments[varargsPosition.intValue()] = Optional.empty();
                        conversionOccurred = true;
                    }
                } else if (!sourceType.equals(targetType3.getElementTypeDescriptor())) {
                    arguments[varargsPosition.intValue()] = converter.convertValue(argument, sourceType, targetType3);
                }
                if (argument == arguments[varargsPosition] || ReflectionHelper.isFirstEntryInArray(argument, arguments[varargsPosition])) break block8;
                conversionOccurred = true;
                break block8;
            }
            targetType = new TypeDescriptor(methodParam).getElementTypeDescriptor();
            Assert.state(targetType != null, "No element type");
            for (int i = varargsPosition.intValue(); i < arguments.length; ++i) {
                Object argument = arguments[i];
                arguments[i] = converter.convertValue(argument, TypeDescriptor.forObject(argument), targetType);
                conversionOccurred |= argument != arguments[i];
            }
        }
        return conversionOccurred;
    }

    public static boolean convertAllMethodHandleArguments(TypeConverter converter, Object[] arguments, MethodHandle methodHandle, @Nullable Integer varargsPosition) throws EvaluationException {
        boolean conversionOccurred;
        block8: {
            TypeDescriptor varArgContentType;
            Object argument;
            block9: {
                MethodType methodHandleArgumentTypes;
                block7: {
                    conversionOccurred = false;
                    methodHandleArgumentTypes = methodHandle.type();
                    if (varargsPosition != null) break block7;
                    for (int i = 0; i < arguments.length; ++i) {
                        TypeDescriptor.OfField argumentClass = methodHandleArgumentTypes.parameterType(i);
                        ResolvableType resolvableType = ResolvableType.forClass(argumentClass);
                        TypeDescriptor targetType = new TypeDescriptor(resolvableType, (Class<?>)argumentClass, null);
                        Object argument2 = arguments[i];
                        arguments[i] = converter.convertValue(argument2, TypeDescriptor.forObject(argument2), targetType);
                        conversionOccurred |= argument2 != arguments[i];
                    }
                    break block8;
                }
                for (int i = 0; i < varargsPosition; ++i) {
                    TypeDescriptor.OfField argumentClass = methodHandleArgumentTypes.parameterType(i);
                    ResolvableType resolvableType = ResolvableType.forClass(argumentClass);
                    TypeDescriptor targetType = new TypeDescriptor(resolvableType, (Class<?>)argumentClass, null);
                    argument = arguments[i];
                    arguments[i] = converter.convertValue(argument, TypeDescriptor.forObject(argument), targetType);
                    conversionOccurred |= argument != arguments[i];
                }
                TypeDescriptor.OfField varArgClass = methodHandleArgumentTypes.lastParameterType().componentType();
                ResolvableType varArgResolvableType = ResolvableType.forClass(varArgClass);
                varArgContentType = new TypeDescriptor(varArgResolvableType, (Class<?>)varArgClass, null);
                if (varargsPosition != arguments.length - 1) break block9;
                Object argument3 = arguments[varargsPosition];
                TypeDescriptor sourceType = TypeDescriptor.forObject(argument3);
                if (argument3 == null) {
                    TypeDescriptor elementDesc = varArgContentType.getElementTypeDescriptor();
                    if (elementDesc != null && elementDesc.getObjectType() == Optional.class) {
                        arguments[varargsPosition.intValue()] = Optional.empty();
                        conversionOccurred = true;
                    }
                } else if (!sourceType.equals(varArgContentType.getElementTypeDescriptor())) {
                    arguments[varargsPosition.intValue()] = converter.convertValue(argument3, sourceType, varArgContentType);
                }
                if (argument3 == arguments[varargsPosition] || ReflectionHelper.isFirstEntryInArray(argument3, arguments[varargsPosition])) break block8;
                conversionOccurred = true;
                break block8;
            }
            for (int i = varargsPosition.intValue(); i < arguments.length; ++i) {
                argument = arguments[i];
                arguments[i] = converter.convertValue(argument, TypeDescriptor.forObject(argument), varArgContentType);
                conversionOccurred |= argument != arguments[i];
            }
        }
        return conversionOccurred;
    }

    private static boolean isFirstEntryInArray(Object value, @Nullable Object possibleArray) {
        if (possibleArray == null) {
            return false;
        }
        Class<?> type = possibleArray.getClass();
        if (!type.isArray() || Array.getLength(possibleArray) == 0 || !ClassUtils.isAssignableValue(type.componentType(), value)) {
            return false;
        }
        Object arrayValue = Array.get(possibleArray, 0);
        return ((Class)type.componentType()).isPrimitive() ? arrayValue.equals(value) : arrayValue == value;
    }

    public static Object[] setupArgumentsForVarargsInvocation(Class<?>[] requiredParameterTypes, Object ... args) {
        Object lastArgument;
        Assert.notEmpty((Object[])requiredParameterTypes, "Required parameter types array must not be empty");
        int parameterCount = requiredParameterTypes.length;
        Class<?> lastRequiredParameterType = requiredParameterTypes[parameterCount - 1];
        Assert.isTrue(lastRequiredParameterType.isArray(), "The last required parameter type must be an array to support varargs invocation");
        int argumentCount = args.length;
        Object object = lastArgument = argumentCount > 0 ? args[argumentCount - 1] : null;
        if (parameterCount != argumentCount || !lastRequiredParameterType.isInstance(lastArgument)) {
            Object[] newArgs = new Object[parameterCount];
            System.arraycopy(args, 0, newArgs, 0, newArgs.length - 1);
            int varargsArraySize = 0;
            if (argumentCount >= parameterCount) {
                varargsArraySize = argumentCount - (parameterCount - 1);
            }
            TypeDescriptor.OfField componentType = lastRequiredParameterType.componentType();
            Object varargsArray = Array.newInstance(componentType, varargsArraySize);
            for (int i = 0; i < varargsArraySize; ++i) {
                Array.set(varargsArray, i, args[parameterCount - 1 + i]);
            }
            newArgs[newArgs.length - 1] = varargsArray;
            return newArgs;
        }
        return args;
    }

    static enum ArgumentsMatchKind {
        EXACT,
        CLOSE,
        REQUIRES_CONVERSION;

    }

    record ArgumentsMatchInfo(ArgumentsMatchKind kind) {
        public boolean isExactMatch() {
            return this.kind == ArgumentsMatchKind.EXACT;
        }

        public boolean isCloseMatch() {
            return this.kind == ArgumentsMatchKind.CLOSE;
        }

        public boolean isMatchRequiringConversion() {
            return this.kind == ArgumentsMatchKind.REQUIRES_CONVERSION;
        }

        @Override
        public String toString() {
            return "ArgumentMatchInfo: " + this.kind;
        }
    }
}

