/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.common.utils;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.apache.shenyu.common.exception.ShenyuException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReflectUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ReflectUtils.class);

    private ReflectUtils() {
    }

    public static Field getField(Class<?> beanClass, String name) throws SecurityException {
        Field[] fields = beanClass.getDeclaredFields();
        return Arrays.stream(fields).filter(field -> Objects.equals(name, field.getName())).findFirst().orElse(null);
    }

    public static Object getFieldValue(Object obj, String fieldName) {
        if (Objects.isNull(obj) || StringUtils.isBlank(fieldName)) {
            return null;
        }
        return ReflectUtils.getFieldValue(obj, ReflectUtils.getField(obj.getClass(), fieldName));
    }

    public static Object getFieldValue(Object obj, Field field) {
        if (Objects.isNull(obj) || Objects.isNull(field)) {
            return null;
        }
        field.setAccessible(true);
        Object result = null;
        try {
            result = field.get(obj);
        }
        catch (IllegalAccessException e) {
            LOG.error("", e);
        }
        return result;
    }

    public static Object invokeStaticMethod(Class<?> clazz, String method) {
        try {
            return MethodUtils.invokeStaticMethod(clazz, method, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            LOG.error("", e);
            return null;
        }
    }

    public static Object invokeMethod(Object object, String method, Consumer<ReflectiveOperationException> errorCallBack, Object ... args) {
        try {
            return MethodUtils.invokeMethod(object, method, args);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            errorCallBack.accept(e);
            return null;
        }
    }

    public static Object invokeMethod(Object object, String method, Object ... args) {
        return ReflectUtils.invokeMethod(object, method, (ReflectiveOperationException e) -> LOG.error("invoke method error"), args);
    }

    public static void setFieldValue(Object obj, String fieldName, Object value) {
        Field field = ReflectUtils.getAccessibleField(obj, fieldName);
        if (Objects.isNull(field)) {
            throw new IllegalArgumentException("Could not find field [" + fieldName + "] on target [" + obj + "]");
        }
        try {
            field.set(obj, value);
        }
        catch (IllegalAccessException e) {
            LOG.error("Failed to assign to the element.", e);
            throw new ShenyuException(e.getMessage());
        }
    }

    private static Field getAccessibleField(Object obj, String fieldName) {
        Validate.notNull(obj, "object can't be null", new Object[0]);
        Validate.notBlank(fieldName, "fieldName can't be blank", new Object[0]);
        for (Class<?> superClass = obj.getClass(); superClass != Object.class; superClass = superClass.getSuperclass()) {
            try {
                Field field = superClass.getDeclaredField(fieldName);
                ReflectUtils.makeAccessible(field);
                return field;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
        }
        return null;
    }

    private static void makeAccessible(Field field) {
        if (!(Modifier.isPublic(field.getModifiers()) && Modifier.isPublic(field.getDeclaringClass().getModifiers()) && !Modifier.isFinal(field.getModifiers()) || field.isAccessible())) {
            field.setAccessible(true);
        }
    }

    public static boolean isPrimitives(Class<?> cls) {
        return cls.isArray() ? ReflectUtils.isPrimitive(cls.getComponentType()) : ReflectUtils.isPrimitive(cls);
    }

    public static boolean isPrimitive(Class<?> cls) {
        return cls.isPrimitive() || cls == String.class || cls == Boolean.class || cls == Character.class || Number.class.isAssignableFrom(cls) || Date.class.isAssignableFrom(cls) || List.class.isAssignableFrom(cls);
    }
}

