/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.common.utils;

import org.apache.commons.lang3.StringUtils;

public final class PathUtils {
    public static String decoratorPath(String contextPath) {
        return StringUtils.contains((CharSequence)contextPath, "/**") ? contextPath : contextPath + "/**";
    }

    public static String decoratorContextPath(String contextPath) {
        return StringUtils.contains((CharSequence)contextPath, "/**") ? StringUtils.substringBefore(contextPath, "/**") : contextPath;
    }

    public static String decoratorPathWithSlash(String contextPath) {
        return StringUtils.endsWith(contextPath, "/") ? contextPath : contextPath + "/";
    }

    public static String pathJoin(String ... path) {
        StringBuilder result = new StringBuilder("/");
        for (String p : path) {
            if (!result.toString().endsWith("/")) {
                result.append("/");
            }
            result.append(p.startsWith("/") ? p.replaceFirst("/", "") : p);
        }
        return result.toString();
    }
}

