/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.common.utils;

import java.io.ByteArrayInputStream;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.shenyu.common.exception.ShenyuException;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JarDependencyUtils {
    private static final Logger LOG = LoggerFactory.getLogger(JarDependencyUtils.class);

    /*
     * Enabled aggressive exception aggregation
     */
    public static Set<String> getDependencyTree(byte[] jarBytes) {
        HashSet<String> dependencies = new HashSet<String>();
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(jarBytes);){
            HashSet<String> hashSet;
            try (ZipInputStream zipInputStream = new ZipInputStream(inputStream);){
                ZipEntry entry;
                while (Objects.nonNull(entry = zipInputStream.getNextEntry())) {
                    if (!entry.getName().endsWith(".class")) continue;
                    ClassNode classNode = new ClassNode(458752);
                    ClassReader classReader = new ClassReader(zipInputStream);
                    classReader.accept(classNode, 0);
                    JarDependencyUtils.addDependencies(classNode.superName, dependencies);
                    for (String interfaceName : classNode.interfaces) {
                        JarDependencyUtils.addDependencies(interfaceName, dependencies);
                    }
                    for (FieldNode fieldNode : classNode.fields) {
                        JarDependencyUtils.addDependencies(Type.getType(fieldNode.desc).getClassName(), dependencies);
                    }
                    for (MethodNode methodNode : classNode.methods) {
                        JarDependencyUtils.addDependencies(Type.getReturnType(methodNode.desc).getClassName(), dependencies);
                        for (Type argumentType : Type.getArgumentTypes(methodNode.desc)) {
                            JarDependencyUtils.addDependencies(argumentType.getClassName(), dependencies);
                        }
                    }
                }
                hashSet = dependencies;
            }
            return hashSet;
        }
        catch (Exception e) {
            LOG.error("get dependency tree error", e);
            throw new ShenyuException("The plugin JAR file is not correct or exceeds 16MB!");
        }
    }

    private static void addDependencies(String typeName, Set<String> dependencies) {
        if (!typeName.startsWith("java") && !typeName.startsWith("javax")) {
            dependencies.add(typeName.replace("/", "."));
        }
    }
}

