/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.common.concurrent;

import java.util.Objects;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.shenyu.common.concurrent.EagerExecutorService;
import org.apache.shenyu.common.concurrent.TaskQueue;

public class ShenyuThreadPoolExecutor
extends ThreadPoolExecutor
implements EagerExecutorService {
    public ShenyuThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, TaskQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
        workQueue.setExecutor(this);
    }

    @Override
    public void execute(Runnable command) {
        if (Objects.isNull(command)) {
            throw new NullPointerException();
        }
        try {
            super.execute(command);
        }
        catch (RejectedExecutionException e) {
            TaskQueue queue = (TaskQueue)super.getQueue();
            try {
                if (!queue.retryOffer(command, 0L, TimeUnit.MILLISECONDS)) {
                    throw new RejectedExecutionException("Queue capacity is full.", e);
                }
            }
            catch (InterruptedException t2) {
                throw new RejectedExecutionException(t2);
            }
        }
    }
}

