/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.util.function;

import com.ctrip.framework.apollo.exceptions.ApolloConfigException;
import com.ctrip.framework.apollo.util.parser.ParserException;
import com.ctrip.framework.apollo.util.parser.Parsers;
import com.google.common.base.Function;
import java.util.Date;

public interface Functions {
    public static final Function<String, Integer> TO_INT_FUNCTION = Integer::parseInt;
    public static final Function<String, Long> TO_LONG_FUNCTION = Long::parseLong;
    public static final Function<String, Short> TO_SHORT_FUNCTION = Short::parseShort;
    public static final Function<String, Float> TO_FLOAT_FUNCTION = Float::parseFloat;
    public static final Function<String, Double> TO_DOUBLE_FUNCTION = Double::parseDouble;
    public static final Function<String, Byte> TO_BYTE_FUNCTION = Byte::parseByte;
    public static final Function<String, Boolean> TO_BOOLEAN_FUNCTION = Boolean::parseBoolean;
    public static final Function<String, Date> TO_DATE_FUNCTION = input -> {
        try {
            return Parsers.forDate().parse((String)input);
        }
        catch (ParserException ex) {
            throw new ApolloConfigException("Parse date failed", ex);
        }
    };
    public static final Function<String, Long> TO_DURATION_FUNCTION = input -> {
        try {
            return Parsers.forDuration().parseToMillis((String)input);
        }
        catch (ParserException ex) {
            throw new ApolloConfigException("Parse duration failed", ex);
        }
    };
}

