/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.spring.config;

import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.ConfigChangeListener;
import com.ctrip.framework.apollo.ConfigService;
import com.ctrip.framework.apollo.build.ApolloInjector;
import com.ctrip.framework.apollo.spring.config.CachedCompositePropertySource;
import com.ctrip.framework.apollo.spring.config.ConfigPropertySource;
import com.ctrip.framework.apollo.spring.config.ConfigPropertySourceFactory;
import com.ctrip.framework.apollo.spring.events.ApolloConfigChangeEvent;
import com.ctrip.framework.apollo.spring.util.PropertySourcesUtil;
import com.ctrip.framework.apollo.spring.util.SpringInjector;
import com.ctrip.framework.apollo.util.ConfigUtil;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.PriorityOrdered;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;

public class PropertySourcesProcessor
implements BeanFactoryPostProcessor,
EnvironmentAware,
ApplicationEventPublisherAware,
PriorityOrdered {
    private static final Multimap<Integer, String> NAMESPACE_NAMES = LinkedHashMultimap.create();
    private static final Set<BeanFactory> AUTO_UPDATE_INITIALIZED_BEAN_FACTORIES = Sets.newConcurrentHashSet();
    private final ConfigPropertySourceFactory configPropertySourceFactory = SpringInjector.getInstance(ConfigPropertySourceFactory.class);
    private ConfigUtil configUtil;
    private ConfigurableEnvironment environment;
    private ApplicationEventPublisher applicationEventPublisher;

    public static boolean addNamespaces(Collection<String> namespaces, int order) {
        return NAMESPACE_NAMES.putAll(order, namespaces);
    }

    @Override
    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        this.configUtil = ApolloInjector.getInstance(ConfigUtil.class);
        this.initializePropertySources();
        this.initializeAutoUpdatePropertiesFeature(beanFactory);
    }

    private void initializePropertySources() {
        if (this.environment.getPropertySources().contains("ApolloPropertySources")) {
            return;
        }
        CompositePropertySource composite = this.configUtil.isPropertyNamesCacheEnabled() ? new CachedCompositePropertySource("ApolloPropertySources") : new CompositePropertySource("ApolloPropertySources");
        ImmutableSortedSet<Integer> orders = ImmutableSortedSet.copyOf(NAMESPACE_NAMES.keySet());
        Iterator iterator = orders.iterator();
        while (iterator.hasNext()) {
            int order = (Integer)iterator.next();
            for (String namespace : NAMESPACE_NAMES.get(order)) {
                Config config = ConfigService.getConfig(namespace);
                composite.addPropertySource(this.configPropertySourceFactory.getConfigPropertySource(namespace, config));
            }
        }
        NAMESPACE_NAMES.clear();
        if (this.environment.getPropertySources().contains("ApolloBootstrapPropertySources")) {
            if (this.configUtil.isOverrideSystemProperties()) {
                PropertySourcesUtil.ensureBootstrapPropertyPrecedence(this.environment);
            }
            this.environment.getPropertySources().addAfter("ApolloBootstrapPropertySources", composite);
        } else {
            if (!this.configUtil.isOverrideSystemProperties() && this.environment.getPropertySources().contains("systemEnvironment")) {
                this.environment.getPropertySources().addAfter("systemEnvironment", composite);
                return;
            }
            this.environment.getPropertySources().addFirst(composite);
        }
    }

    private void initializeAutoUpdatePropertiesFeature(ConfigurableListableBeanFactory beanFactory) {
        if (!AUTO_UPDATE_INITIALIZED_BEAN_FACTORIES.add(beanFactory)) {
            return;
        }
        ConfigChangeListener configChangeEventPublisher = changeEvent -> this.applicationEventPublisher.publishEvent(new ApolloConfigChangeEvent(changeEvent));
        List<ConfigPropertySource> configPropertySources = this.configPropertySourceFactory.getAllConfigPropertySources();
        for (ConfigPropertySource configPropertySource : configPropertySources) {
            configPropertySource.addChangeListener(configChangeEventPublisher);
        }
    }

    @Override
    public void setEnvironment(Environment environment2) {
        this.environment = (ConfigurableEnvironment)environment2;
    }

    @Override
    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    static void reset() {
        NAMESPACE_NAMES.clear();
        AUTO_UPDATE_INITIALIZED_BEAN_FACTORIES.clear();
    }

    @Override
    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }
}

