/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.aot;

import java.util.Arrays;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.annotation.ReflectiveRuntimeHintsRegistrar;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotContribution;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotProcessor;
import org.springframework.beans.factory.aot.BeanFactoryInitializationCode;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.RegisteredBean;

class ReflectiveProcessorBeanFactoryInitializationAotProcessor
implements BeanFactoryInitializationAotProcessor {
    private static final ReflectiveRuntimeHintsRegistrar registrar = new ReflectiveRuntimeHintsRegistrar();

    ReflectiveProcessorBeanFactoryInitializationAotProcessor() {
    }

    @Override
    public BeanFactoryInitializationAotContribution processAheadOfTime(ConfigurableListableBeanFactory beanFactory) {
        Class[] beanTypes = (Class[])Arrays.stream(beanFactory.getBeanDefinitionNames()).map(beanName -> RegisteredBean.of(beanFactory, beanName).getBeanClass()).toArray(Class[]::new);
        return new ReflectiveProcessorBeanFactoryInitializationAotContribution(beanTypes);
    }

    private static class ReflectiveProcessorBeanFactoryInitializationAotContribution
    implements BeanFactoryInitializationAotContribution {
        private final Class<?>[] types;

        public ReflectiveProcessorBeanFactoryInitializationAotContribution(Class<?>[] types) {
            this.types = types;
        }

        @Override
        public void applyTo(GenerationContext generationContext, BeanFactoryInitializationCode beanFactoryInitializationCode) {
            RuntimeHints runtimeHints = generationContext.getRuntimeHints();
            registrar.registerRuntimeHints(runtimeHints, this.types);
        }
    }
}

