/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web.embedded;

import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.server.AbstractConnector;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.CustomRequestLog;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.RequestLogWriter;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.autoconfigure.web.embedded.JettyThreadPool;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.web.embedded.jetty.ConfigurableJettyWebServerFactory;
import org.springframework.boot.web.embedded.jetty.JettyServerCustomizer;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.core.Ordered;
import org.springframework.core.env.Environment;
import org.springframework.util.CollectionUtils;
import org.springframework.util.unit.DataSize;

public class JettyWebServerFactoryCustomizer
implements WebServerFactoryCustomizer<ConfigurableJettyWebServerFactory>,
Ordered {
    static final int ORDER = 0;
    private final Environment environment;
    private final ServerProperties serverProperties;

    public JettyWebServerFactoryCustomizer(Environment environment2, ServerProperties serverProperties) {
        this.environment = environment2;
        this.serverProperties = serverProperties;
    }

    @Override
    public int getOrder() {
        return 0;
    }

    @Override
    public void customize(ConfigurableJettyWebServerFactory factory) {
        ServerProperties.Jetty properties = this.serverProperties.getJetty();
        factory.setUseForwardHeaders(this.getOrDeduceUseForwardHeaders());
        ServerProperties.Jetty.Threads threadProperties = properties.getThreads();
        factory.setThreadPool((ThreadPool)JettyThreadPool.create(properties.getThreads()));
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        map.from(properties::getMaxConnections).to(factory::setMaxConnections);
        map.from(threadProperties::getAcceptors).to(factory::setAcceptors);
        map.from(threadProperties::getSelectors).to(factory::setSelectors);
        map.from(this.serverProperties::getMaxHttpRequestHeaderSize).asInt(DataSize::toBytes).when(this::isPositive).to(maxHttpRequestHeaderSize -> factory.addServerCustomizers(new MaxHttpRequestHeaderSizeCustomizer((int)maxHttpRequestHeaderSize)));
        map.from(properties::getMaxHttpResponseHeaderSize).asInt(DataSize::toBytes).when(this::isPositive).to(maxHttpResponseHeaderSize -> factory.addServerCustomizers(new MaxHttpResponseHeaderSizeCustomizer((int)maxHttpResponseHeaderSize)));
        map.from(properties::getMaxHttpFormPostSize).asInt(DataSize::toBytes).when(this::isPositive).to(maxHttpFormPostSize -> this.customizeMaxHttpFormPostSize(factory, (int)maxHttpFormPostSize));
        map.from(properties::getConnectionIdleTimeout).to(idleTimeout -> this.customizeIdleTimeout(factory, (Duration)idleTimeout));
        map.from(properties::getAccesslog).when(ServerProperties.Jetty.Accesslog::isEnabled).to(accesslog -> this.customizeAccessLog(factory, (ServerProperties.Jetty.Accesslog)accesslog));
    }

    private boolean isPositive(Integer value) {
        return value > 0;
    }

    private boolean getOrDeduceUseForwardHeaders() {
        if (this.serverProperties.getForwardHeadersStrategy() == null) {
            CloudPlatform platform = CloudPlatform.getActive(this.environment);
            return platform != null && platform.isUsingForwardHeaders();
        }
        return this.serverProperties.getForwardHeadersStrategy().equals((Object)ServerProperties.ForwardHeadersStrategy.NATIVE);
    }

    private void customizeIdleTimeout(ConfigurableJettyWebServerFactory factory, Duration connectionTimeout) {
        factory.addServerCustomizers(server -> {
            for (Connector connector : server.getConnectors()) {
                if (!(connector instanceof AbstractConnector)) continue;
                AbstractConnector abstractConnector = (AbstractConnector)connector;
                abstractConnector.setIdleTimeout(connectionTimeout.toMillis());
            }
        });
    }

    private void customizeMaxHttpFormPostSize(ConfigurableJettyWebServerFactory factory, final int maxHttpFormPostSize) {
        factory.addServerCustomizers(new JettyServerCustomizer(){

            @Override
            public void customize(Server server) {
                this.setHandlerMaxHttpFormPostSize(server.getHandlers());
            }

            private void setHandlerMaxHttpFormPostSize(List<Handler> handlers) {
                for (Handler handler : handlers) {
                    this.setHandlerMaxHttpFormPostSize(handler);
                }
            }

            private void setHandlerMaxHttpFormPostSize(Handler handler) {
                if (handler instanceof ServletContextHandler) {
                    ServletContextHandler contextHandler = (ServletContextHandler)handler;
                    contextHandler.setMaxFormContentSize(maxHttpFormPostSize);
                } else if (handler instanceof Handler.Wrapper) {
                    Handler.Wrapper wrapper = (Handler.Wrapper)handler;
                    this.setHandlerMaxHttpFormPostSize(wrapper.getHandler());
                } else if (handler instanceof Handler.Collection) {
                    Handler.Collection collection = (Handler.Collection)handler;
                    this.setHandlerMaxHttpFormPostSize(collection.getHandlers());
                }
            }
        });
    }

    private void customizeAccessLog(ConfigurableJettyWebServerFactory factory, ServerProperties.Jetty.Accesslog properties) {
        factory.addServerCustomizers(server -> {
            RequestLogWriter logWriter = new RequestLogWriter();
            String format = this.getLogFormat(properties);
            CustomRequestLog log = new CustomRequestLog((RequestLog.Writer)logWriter, format);
            if (!CollectionUtils.isEmpty(properties.getIgnorePaths())) {
                log.setIgnorePaths(properties.getIgnorePaths().toArray(new String[0]));
            }
            if (properties.getFilename() != null) {
                logWriter.setFilename(properties.getFilename());
            }
            if (properties.getFileDateFormat() != null) {
                logWriter.setFilenameDateFormat(properties.getFileDateFormat());
            }
            logWriter.setRetainDays(properties.getRetentionPeriod());
            logWriter.setAppend(properties.isAppend());
            server.setRequestLog((RequestLog)log);
        });
    }

    private String getLogFormat(ServerProperties.Jetty.Accesslog properties) {
        if (properties.getCustomFormat() != null) {
            return properties.getCustomFormat();
        }
        if (ServerProperties.Jetty.Accesslog.FORMAT.EXTENDED_NCSA.equals((Object)properties.getFormat())) {
            return "%{client}a - %u %t \"%r\" %s %O \"%{Referer}i\" \"%{User-Agent}i\"";
        }
        return "%{client}a - %u %t \"%r\" %s %O";
    }

    private static class MaxHttpResponseHeaderSizeCustomizer
    implements JettyServerCustomizer {
        private final int maxResponseHeaderSize;

        MaxHttpResponseHeaderSizeCustomizer(int maxResponseHeaderSize) {
            this.maxResponseHeaderSize = maxResponseHeaderSize;
        }

        @Override
        public void customize(Server server) {
            Arrays.stream(server.getConnectors()).forEach(this::customize);
        }

        private void customize(Connector connector) {
            connector.getConnectionFactories().forEach(this::customize);
        }

        private void customize(ConnectionFactory factory) {
            if (factory instanceof HttpConfiguration.ConnectionFactory) {
                HttpConfiguration.ConnectionFactory httpConnectionFactory = (HttpConfiguration.ConnectionFactory)factory;
                httpConnectionFactory.getHttpConfiguration().setResponseHeaderSize(this.maxResponseHeaderSize);
            }
        }
    }

    private static class MaxHttpRequestHeaderSizeCustomizer
    implements JettyServerCustomizer {
        private final int maxRequestHeaderSize;

        MaxHttpRequestHeaderSizeCustomizer(int maxRequestHeaderSize) {
            this.maxRequestHeaderSize = maxRequestHeaderSize;
        }

        @Override
        public void customize(Server server) {
            Arrays.stream(server.getConnectors()).forEach(this::customize);
        }

        private void customize(Connector connector) {
            connector.getConnectionFactories().forEach(this::customize);
        }

        private void customize(ConnectionFactory factory) {
            if (factory instanceof HttpConfiguration.ConnectionFactory) {
                ((HttpConfiguration.ConnectionFactory)factory).getHttpConfiguration().setRequestHeaderSize(this.maxRequestHeaderSize);
            }
        }
    }
}

