/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.common.timer;

import java.util.Objects;
import org.apache.shenyu.common.timer.TaskEntity;
import org.apache.shenyu.common.timer.Timer;
import org.apache.shenyu.common.timer.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRetryTask
extends TimerTask {
    private final Logger logger = LoggerFactory.getLogger(AbstractRetryTask.class);
    private final String key;
    private final Integer retryCount;
    private int tickCount = 1;
    private final boolean retryLimit;

    public AbstractRetryTask(String key, long delayMs) {
        this(key, delayMs, 1);
    }

    public AbstractRetryTask(String key, long delayMs, Integer retryCount) {
        this(key, delayMs, retryCount, retryCount < 0);
    }

    public AbstractRetryTask(String key, long delayMs, Integer retryCount, boolean retryLimit) {
        super(delayMs);
        this.key = key;
        this.retryCount = retryCount;
        this.retryLimit = retryLimit;
    }

    protected void again(TaskEntity taskEntity) {
        Timer timer = taskEntity.getTimer();
        if (Objects.isNull(timer)) {
            return;
        }
        TimerTask timerTask = taskEntity.getTimerTask();
        if (Objects.isNull(timerTask)) {
            return;
        }
        if (taskEntity.cancelled()) {
            return;
        }
        timer.add(timerTask);
        ++this.tickCount;
    }

    @Override
    public void run(TaskEntity taskEntity) {
        if (Objects.isNull(taskEntity)) {
            return;
        }
        if (taskEntity.cancelled()) {
            return;
        }
        if (!this.retryLimit && this.tickCount > this.retryCount) {
            this.logger.warn("Final failed to execute task, key:{},retried:{},task over.", (Object)this.key, (Object)this.tickCount);
            return;
        }
        try {
            this.doRetry(this.key, taskEntity.getTimerTask());
        }
        catch (Throwable ex) {
            this.logger.warn("Failed to execute task:{},retried\uff1a{} ,total retries:{},cause:{}", this.key, this.tickCount, this.retryCount, ex.getMessage());
            this.again(taskEntity);
        }
    }

    protected abstract void doRetry(String var1, TimerTask var2);
}

