/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.util;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class OrderedProperties
extends Properties {
    private static final long serialVersionUID = -1741073539526213291L;
    private final Set<String> propertyNames = Collections.synchronizedSet(new LinkedHashSet());

    @Override
    public synchronized Object put(Object key, Object value) {
        this.addPropertyName(key);
        return super.put(key, value);
    }

    private void addPropertyName(Object key) {
        if (key instanceof String) {
            this.propertyNames.add((String)key);
        }
    }

    @Override
    public Set<String> stringPropertyNames() {
        return this.propertyNames;
    }

    @Override
    public Enumeration<?> propertyNames() {
        return Collections.enumeration(this.propertyNames);
    }

    @Override
    public synchronized Enumeration<Object> keys() {
        return new Enumeration<Object>(){
            private final Iterator<String> i;
            {
                this.i = OrderedProperties.this.propertyNames.iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.i.hasNext();
            }

            @Override
            public Object nextElement() {
                return this.i.next();
            }
        };
    }

    @Override
    public Set<Object> keySet() {
        return new LinkedHashSet<Object>(this.propertyNames);
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        Set<Map.Entry<Object, Object>> original = super.entrySet();
        LinkedHashMap<String, Map.Entry> entryMap = new LinkedHashMap<String, Map.Entry>();
        for (String string : this.propertyNames) {
            entryMap.put(string, null);
        }
        for (Map.Entry entry : original) {
            entryMap.put((String)entry.getKey(), entry);
        }
        return new LinkedHashSet<Map.Entry<Object, Object>>(entryMap.values());
    }

    @Override
    public synchronized void putAll(Map<?, ?> t2) {
        super.putAll(t2);
        for (Object name : t2.keySet()) {
            this.addPropertyName(name);
        }
    }

    @Override
    public synchronized void clear() {
        super.clear();
        this.propertyNames.clear();
    }

    @Override
    public synchronized Object remove(Object key) {
        if (key instanceof String) {
            this.propertyNames.remove(key);
        }
        return super.remove(key);
    }
}

